% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BB7copula.R
\name{BB7Copula}
\alias{BB7Copula}
\alias{r270BB7Copula}
\alias{r90BB7Copula}
\alias{surBB7Copula}
\title{Constructor of the BB7 Family and Rotated Versions thereof}
\usage{
BB7Copula(param = c(1, 1))
}
\arguments{
\item{param}{The parameter \code{param} defines the copula through
\code{theta} and \code{delta}.}
}
\value{
One of the respective BB7 copula classes
(\code{\linkS4class{BB7Copula}}, \code{\linkS4class{surBB7Copula}},
\code{\linkS4class{r90BB7Copula}}, \code{\linkS4class{r270BB7Copula}}).
}
\description{
Constructs an object of the \code{\linkS4class{BB7Copula}} (survival
\code{sur}, 90 degree rotated \code{r90} and 270 degree rotated \code{r270})
family for given parameters.
}
\examples{

library(copula)

persp(BB7Copula(c(1,1.5)), dCopula, zlim = c(0,10))
persp(surBB7Copula(c(1,1.5)), dCopula, zlim = c(0,10))
persp(r90BB7Copula(c(-1,-1.5)), dCopula, zlim = c(0,10))
persp(r270BB7Copula(c(-1,-1.5)), dCopula, zlim = c(0,10))

}
\author{
Benedikt Graeler
}
\references{
Joe, H., (1997). Multivariate Models and Dependence Concepts.
Monogra. Stat. Appl. Probab. 73, London: Chapman and Hall.
}
\seealso{
See also \code{\link{BB6Copula}}, \code{\link{BB7Copula}},
\code{\link{BB8Copula}} and \code{\link{joeCopula}} for further wrapper
functions to the \code{\link{VineCopula-package}}.
}

