% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VgConLenViolin.R
\name{VgConLenViolin}
\alias{VgConLenViolin}
\title{VgConLenViolin: Generate a Violinplot of contig length for each group (Gatherer only)}
\usage{
VgConLenViolin(
  vg_file = vg_file,
  taxa_rank = "Family",
  cut = 1e-05,
  log10_scale = TRUE,
  reorder_criteria = "median",
  adjust_bw = 1,
  jitter_point = FALSE,
  theme_choice = "linedraw",
  flip_coords = TRUE,
  title = "Violinplot of contig length for each group",
  title_size = 16,
  title_face = "bold",
  title_colour = "#2a475e",
  subtitle = NULL,
  subtitle_size = 12,
  subtitle_face = "bold",
  subtitle_colour = "#1b2838",
  xlabel = "Viral group",
  ylabel = "Contig length (nt)",
  axis_title_size = 12,
  xtext_size = 10,
  x_angle = NULL,
  ytext_size = 10,
  y_angle = NULL,
  remove_group_labels = FALSE,
  legend_title = "Phylum",
  legend_position = "bottom",
  legend_title_size = 12,
  legend_title_face = "bold",
  legend_text_size = 10,
  min_observations = 1,
  facet_ncol = NULL,
  add_boxplot = FALSE,
  group_unwanted_phyla = NULL
)
}
\arguments{
\item{vg_file}{A data frame containing VirusGatherer hittable results.}

\item{taxa_rank}{(optional): Specify the taxonomic rank to group your data by.
Supported ranks are:
\itemize{
\item "Subphylum"
\item "Class"
\item "Subclass"
\item "Order"
\item "Suborder"
\item "Family" (default)
\item "Subfamily"
\item "Genus" (including Subgenus)
}}

\item{cut}{(optional): A numeric value representing the cutoff for the refseq E-value (default: 1e-5).}

\item{log10_scale}{(optinal): transform y-axis to log10 scale (default: TRUE).}

\item{reorder_criteria}{Character string specifying the criteria for reordering the x-axis ('max', 'min', 'median'(Default),'mean','phylum').
NULL sorts alphabetically. You can also specify criteria with 'phylum_' prefix (e.g., 'phylum_median') to sort by phylum first and then by the specified statistic within each phylum.}

\item{adjust_bw}{(optional): control the bandwidth of the kernel density estimator used to create the violin plot.
A higher value results in a smoother plot by increasing the bandwidth, while a lower value can make the plot more detailed but potentially noisier (default: 1).}

\item{jitter_point}{(optional): logical: TRUE to show all observations, FALSE to show only groups with less than 2 observations (default: FALSE).}

\item{theme_choice}{(optional): A character indicating the ggplot2 theme to apply. Options include "minimal",
"classic", "light", "dark", "void", "grey" (or "gray"), "bw", "linedraw" (default), and "test".
Append "_dotted" to any theme to add custom dotted grid lines (e.g., "classic_dotted").}

\item{flip_coords}{(optional): Logical indicating whether to flip the coordinates of the plot (default: TRUE).}

\item{title}{(optional): The title of the plot (default: "Violinplot of contig length for each group").}

\item{title_size}{(optional): The size of the title text (default: 16).}

\item{title_face}{(optional): The face (bold, italic, etc.) of the title text (default: "bold").}

\item{title_colour}{(optional): The color of the title text (default: "#2a475e").}

\item{subtitle}{(optional): A character specifying the subtitle of the plot (default: NULL).}

\item{subtitle_size}{(optional): Numeric specifying the size of the subtitle text(default: 12).}

\item{subtitle_face}{(optional): A character specifying the font face for the subtitle text (default: "bold").}

\item{subtitle_colour}{(optional): A character specifying the color for the subtitle text (default: "#1b2838").}

\item{xlabel}{(optional): The label for the x-axis (default: "Viral group").}

\item{ylabel}{(optional): The label for the y-axis (default: "Contig length (nt)").}

\item{axis_title_size}{(optional): The size of the axis titles (default: 12).}

\item{xtext_size}{(optional): The size of the x-axis text (default: 10).}

\item{x_angle}{(optional): An integer specifying the angle (in degrees) for the x-axis text labels. Default is NULL, meaning no change.}

\item{ytext_size}{(optional): The size of the y-axis text (default: 10).}

\item{y_angle}{(optional): An integer specifying the angle (in degrees) for the y-axis text labels. Default is NULL, meaning no change.}

\item{remove_group_labels}{(optional): If \code{TRUE}, the group labels will be removed; if \code{FALSE} or omitted, the labels will be displayed.}

\item{legend_title}{(optional): A character specifying the title for the legend (default: "Phylum").}

\item{legend_position}{(optional): The position of the legend (default: "bottom).}

\item{legend_title_size}{(optional): Numeric specifying the size of the legend title text (default: 12).}

\item{legend_title_face}{(optional): A character specifying the font face for the legend title text (default: "bold").}

\item{legend_text_size}{(optional): Numeric specifying the size of the legend text (default: 10).}

\item{min_observations}{(optional): Minimum number of observations required per group to be included in the plot (default: 1).}

\item{facet_ncol}{(optional):  The number of columns for faceting (default: NULL).
It is recommended to specify this when the number of viral groups is high, to ensure they fit well in one plot.}

\item{add_boxplot}{(optional): Add a boxplot to the violin plot (default: FALSE).}

\item{group_unwanted_phyla}{(optional): A character string specifying which group of viral phyla to retain in the analysis.
Valid values are:
\describe{
\item{"rna"}{Retain only the phyla specified for RNA viruses.}
\item{"smalldna"}{Retain only the phyla specified for small DNA viruses.}
\item{"largedna"}{Retain only the phyla specified for large DNA viruses.}
\item{"others"}{Retain only the phyla that match small DNA, Large DNA and RNA viruses.}
}
All other phyla not in the specified group will be grouped into a single category:
"Non-RNA-virus" for \code{"rna"}, "Non-Small-DNA-Virus" for \code{"smalldna"},"Non-Large-DNA-Virus" for \code{"largedna"},or "Other Viruses" for \code{"others"}.}
}
\value{
A list containing the following components:
\itemize{
\item plot: A plot object representing the violin plot.
\item contiglen_stats: A tibble data frame with summary statistics for "contig_len" values.
}
}
\description{
VgConLenViolin creates a violin plot to visualize the distribution of contig lengths
for each group in VirusGatherer hittables.
}
\details{
VgConLenViolin creates a violin plot to visualize the distribution of contig lengths
for each group in the "ViralRefSeq_taxonomy" column of the VirusGatherer hittable.
The x-axis represents the groups as defined by the "ViralRefSeq_taxonomy" column,
and the y-axis represents the contig lengths.

By default, the y-axis is transformed to a log10 scale to better visualize differences
in contig lengths across groups. This transformation can be disabled by setting the
\code{log10_scale} argument to FALSE.

\code{min_observations} filters the data sets to include only groups with at least the specified number of observations
before plotting them. This feature allows users to exclude groups with insufficient data.
By default, every group is plotted, as the minimum requirement is set to at least one observation per group.
}
\examples{

# import gatherer files
path2 <- system.file("extdata", "virusgatherer.tsv", package = "Virusparies")
vg_file <- ImportVirusTable(path2)

# create a violinplot.
violinplot <- VgConLenViolin(vg_file=vg_file,cut = 1e-5,log10_scale = TRUE)

violinplot


}
\seealso{
VirusHunterGatherer is available here: \url{https://github.com/lauberlab/VirusHunterGatherer}.
}
\author{
Sergej Ruff
}
