% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{new_visitation_model}
\alias{new_visitation_model}
\title{"visitation_model" Constructor Function}
\usage{
new_visitation_model(
  visitation_fit,
  differenced_fit,
  beta,
  constant,
  slope,
  lag_estimate,
  proxy_decomposition,
  onsite_usage_decomposition,
  forecasts_needed,
  ref_series,
  criterion,
  omit_trend,
  trend,
  call
)
}
\arguments{
\item{visitation_fit}{A time series storing the fitted values of the visitation model.}

\item{differenced_fit}{A time series storing the differenced fitted values of the visitation model.}

\item{beta}{Seasonality adjustment factor. (beta_1)}

\item{constant}{A numeric describing the constant term used in the model. (beta_0)}

\item{slope}{A numeric describing the slope term used in the model when trend is set to "linear". (beta_2)}

\item{lag_estimate}{An integer representing the lag parameter for the model fit.}

\item{proxy_decomposition}{A decomposition class object representing the decomposition of a popularity measure (e.g., US Photo-User-Days).}

\item{onsite_usage_decomposition}{A decomposition class object representing the decomposition of time series (e.g., park Photo-User-Days).}

\item{forecasts_needed}{An integer describing how many forecasts for the proxy_decomposition are needed for the fit.}

\item{ref_series}{A reference time series (or NULL) used in the model fit.}

\item{criterion}{A character string specifying the criterion for estimating the lag in popularity_proxy. If "cross-correlation" is chosen, it chooses the lag that maximizes the correlation coefficient between lagged popularity_proxy and onsite_usage. If "MSE" is chosen, it does so by identifying the lagged popularity_proxy whose derivative is closest to that of onsite_usage by minimizing the mean squared error. If "rank" is chosen, it does so by firstly ranking the square errors of the derivatives and identifying the lag which would minimize the mean rank.}

\item{omit_trend}{This is obsolete and is left only for compatibility. A Boolean specifying whether or not to consider the NPS trend to be zero.}

\item{trend}{A character string specifying how the trend is modeled. Can be any of NULL, "linear", "none", and "estimated", where "none" and "estimated" correspond to \code{omit_trend} being TRUE and FALSE, respectively. If NULL, then it follows the value specified in \code{omit_trend}.}

\item{call}{A call for the visitation model.}
}
\value{
A list of the class "model_forecast".
}
\description{
Constructs objects of the "visitation_model" class.
}
