\name{summary.warnProb}
\alias{summary.warnProb}
\title{
  Summaries of probabilities of posterior weaning parameters
}
\description{
  \code{summary.warnProb} calculates simple summaries of probabilities of posterior samples for the four weaning parameters, which is the intended weaning paramter, designated parameter range, and calculate posterior probability of the weaning parameter that ranges between the range.
}
\usage{
\method{summary}{warnProb}(object, \dots)
}
\arguments{
  \item{object}{an object of class \code{"warnProb"} generated by \code{\link{warnProb}}.}
  \item{\dots}{additional arguments affecting the summary produced.}
}
\value{
  \code{summary.warnProb} returns a list containing following components and those succeeded from \code{"warnProb"}:\cr
  \item{call}{the matched call.}
  \item{range}{a vector giving the range of the intended weanig parameter.}
  \item{probability}{posterior probability of parameter in the designated range.}
  \item{weaning.par}{a character indicating the weaning parameter used.}
}
\references{
  Tsutaya, T., and Yoneda, M. 2013. WARN: an R package for quantitative reconstruction of weaning ages in archaeological populations using bone collagen nitrogen isotope ratios. \href{http://arxiv.org/abs/1304.2468}{arXiv:1304.2468}.
}
\seealso{
  \code{\link{WARN}}, \code{\link{warn}}, \code{\link{warnProb}},  \code{\link{plot.warnProb}}
}
\examples{
## See ?warnProb for examples.
}
\keyword{math}
