% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/confidenceBands.R
\name{confidenceBands}
\alias{confidenceBands}
\title{Confidence Bands for Wasserstein Regression}
\usage{
confidenceBands(
  wass_regress_res,
  Xpred_df,
  level = 0.95,
  delta = 0.01,
  type = "density",
  figure = TRUE,
  fig_num = NULL
)
}
\arguments{
\item{wass_regress_res}{an object returned by the \code{wass_regress} function}

\item{Xpred_df}{k-by-p matrix (or dataframe, or named vector) used for prediction. Note that Xpred_df should have the same column names with Xfit_df used in wass_regress_res}

\item{level}{confidence level}

\item{delta}{boundary control value in density band computation. Must be a value in the interval (0, 1/2) (default: 0.01)}

\item{type}{'density', 'quantile' or 'both'
\itemize{
\item{'density': density function bands will be returned (and plotted if \code{figure = TRUE}) }
\item{'quantile': quantile function and CDF bands will be returned (and plotted if \code{figure = TRUE}) }
\item{'both': three kinds of bands, density function, quantile function and CDF bands will be returned (and plotted if \code{figure = TRUE}) }
}}

\item{figure}{logical; if TRUE, return a sampled plot (default: TRUE)}

\item{fig_num}{the fig_num-th row of \code{Xpred_df} will be used for visualization of confidence bands. If NULL, then \code{fig_num} is randomly chosen (default: NULL)}
}
\value{
a list containing the following lists:
\item{den_list:}{
\itemize{
\item{fpred:} {k-by-m matrix, predicted density function at Xpred_df.}
\item{f_ux:} {k-by-m matrix, upper bound of confidence bands of density functions.}
\item{f_lx:} {k-by-m matrix, lower bound of confidence bands of density functions.}
\item{Qpred:} {k-by-m matrix, f_lx[i, ], f_ux[i, ] and fpred[i, ] evaluated on Qpred[i, ] vector.}
}}
\item{quan_list:}{
\itemize{
\item{Qpred:} {k-by-m matrix of predicted quantile functions.}
\item{Q_ux:} {k-by-m matrix of upper bound of quantile functions.}
\item{Q_lx:} {k-by-m matrix of lower bound of quantile functions.}
\item{t_vec:} {a length m vector - common grid for all quantile functions.}}}
\item{cdf_list:}{
\itemize{
\item{fpred:} {k-by-m matrix, predicted density function.}
\item{Fpred:} {k-by-m matrix, predicted cumulative distribution functions.}
\item{F_ux:} {k-by-m matrix, upper bound of cumulative distribution functions.}
\item{F_lx:} {k-by-m matrix, lower bound of cumulative distribution functions.}
\item{Fsup:} {k-by-m matrix, fpred[i, ], F_lx[i, ], F_ux[i, ] and Fpred[i, ] evaluated on Fsup[i, ] vector.}}}
}
\description{
Confidence Bands for Wasserstein Regression
}
\details{
This function computes intrinsic confidence bands for \code{Xpred_df} if \code{type} = 'quantile' and density bands if \code{type} = 'density', and visualizes the confidence and/or density bands when \code{figure} = TRUE.
}
\examples{
alpha = 2
beta = 1
n = 50
x1 = runif(n)
t_vec = unique(c(seq(0, 0.05, 0.001), seq(0.05, 0.95, 0.05), seq(0.95, 1, 0.001)))
set.seed(1)
quan_obs = simulate_quantile_curves(x1, alpha, beta, t_vec)
Xfit_df = data.frame(x1 = x1)
res = wass_regress(rightside_formula = ~., Xfit_df = Xfit_df,
                   Ytype = 'quantile', Ymat = quan_obs, Sup = t_vec)
confidence_Band = confidenceBands(res, Xpred_df = data.frame(x1 = c(-0.5,0.5)),
type = 'both', fig_num = 2)
\donttest{
data(strokeCTdensity)
predictor = strokeCTdensity$predictors
dSup = strokeCTdensity$densitySupport
densityCurves = strokeCTdensity$densityCurve
xpred = predictor[2:3, ]

res = wass_regress(rightside_formula = ~., Xfit_df = predictor,
Ytype = 'density', Ymat = densityCurves, Sup = dSup)
confidence_Band = confidenceBands(res, Xpred_df = xpred, type = 'density', fig_num = 1)
}
}
