% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ROC.R
\name{ROCPlot}
\alias{ROCPlot}
\title{Plot receiver operating characteristic plot.}
\usage{
ROCPlot(
  frame,
  xvar,
  truthVar,
  truthTarget,
  title,
  ...,
  estimate_sig = FALSE,
  returnScores = FALSE,
  nrep = 100,
  parallelCluster = NULL,
  curve_color = "darkblue",
  fill_color = "black",
  diag_color = "black"
)
}
\arguments{
\item{frame}{data frame to get values from}

\item{xvar}{name of the independent (input or model) column in frame}

\item{truthVar}{name of the dependent (output or result to be modeled) column in frame}

\item{truthTarget}{value we consider to be positive}

\item{title}{title to place on plot}

\item{...}{no unnamed argument, added to force named binding of later arguments.}

\item{estimate_sig}{logical, if TRUE estimate and display significance of difference from AUC 0.5.}

\item{returnScores}{logical if TRUE return detailed permutedScores}

\item{nrep}{number of permutation repetitions to estimate p values.}

\item{parallelCluster}{(optional) a cluster object created by package parallel or package snow.}

\item{curve_color}{color of the ROC curve}

\item{fill_color}{shading color for the area under the curve}

\item{diag_color}{color for the AUC=0.5 line (x=y)}
}
\description{
Plot receiver operating characteristic plot.
}
\details{
See https://www.nature.com/articles/nmeth.3945 for a discussion of
true positive and false positive rates,
and how the ROC plot relates to the precision/recall plot.
}
\examples{

set.seed(34903490)
x = rnorm(50)
y = 0.5*x^2 + 2*x + rnorm(length(x))
frm = data.frame(x=x,yC=y>=as.numeric(quantile(y,probs=0.8)))
WVPlots::ROCPlot(frm, "x", "yC", TRUE, title="Example ROC plot", estimate_sig = TRUE)

}
\seealso{
\code{\link{PRTPlot}}, \code{\link{ThresholdPlot}}
}
