% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\encoding{UTF-8}
\name{IB}
\alias{IB}
\title{Spreading measure based on Moran's \eqn{I} index}
\usage{
IB(W, s)
}
\arguments{
\item{W}{a stratification matrix inheriting from \code{\link[Matrix]{sparseMatrix}} that represents the spatial weights. See \code{\link{wpik}}.}

\item{s}{a vector of size \eqn{N} with elements equal to 0 or 1. The value 1 indicates that the unit is selected while the value 0 is for non-chosen units.}
}
\value{
A numeric value that represents the spatial balance. It could be any real value between -1 (spread) and 1 (clustered).
}
\description{
This function implements the spreading measure based on Moran's \eqn{I} index.
}
\details{
This index is developped by Tillé et al. (2018) and measure the spreading of a sample drawn from a population.
It uses a corrected version of the traditional Moran's \eqn{I} index. Each row of the matrix \eqn{\bf W} should represents a stratum. Each 
stratum is defined by a particular unit and its neighbouring units. See \code{\link{wpik}}.
The spatial balance measure is equal to

\deqn{I_B =\frac{( \bf s- \bar{s}_w)^\top  W ( s- \bar{s}_w)}{\bf \sqrt{( s- \bar{s}_w)^\top  D ( s- \bar{s}_w) ( s- \bar{s}_w)^\top  B ( s- \bar{s}_w)}},}

where \eqn{\bf D} is the diagonal matrix containing the \eqn{w_i}, 

\deqn{ \bf \bar{s}_w =  1 \frac{ s^\top  W  1}{ 1^\top  W  1}}

and 

\deqn{ \bf B =  W^\top  D^{-1}  W - \frac{ W^\top  1 1^\top  W}{1^\top  W  1}.}

To specify the spatial weights uses the argument \code{W}.
}
\examples{
  N <- 36
  n <- 12
  x <- seq(1,sqrt(N),1)
  X <- expand.grid(x,x)
  pik <- rep(n/N,N)
  W <- wpik(as.matrix(X),pik,bound = 1,tore = TRUE,shift = FALSE,toreBound = sqrt(N))
  W <- W - diag(diag(W))
  s <- wave(as.matrix(X),pik,tore = TRUE,shift = TRUE,comment = TRUE)
  IB(W,s)

}
\references{
Tillé, Y., Dickson, M.M., Espa, G., and Guiliani, D. (2018). Measuring the spatial balance of a sample: A new measure based on Moran's I index.
\emph{Spatial Statistics}, 23, 182-192.
}
\seealso{
\code{\link{wpik}}
}
\author{
Raphaël Jauslin \email{raphael.jauslin@unine.ch}
}
