% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model58.R
\name{wp.modmed.m58}
\alias{wp.modmed.m58}
\title{model58}
\usage{
wp.modmed.m58(
  c1 = 0.5,
  a1 = 0.75,
  c2 = 0.1,
  d1 = 0.4,
  b1 = 0.6,
  b2 = 0.1,
  cp = 0.5,
  sigx2 = 1,
  sigw2 = 1,
  sige12 = 1,
  sige22 = 1,
  sigx_w = 0.4,
  n = 100,
  nrep = 100,
  alpha = 0.05,
  b = 1000,
  nb = n,
  w_value = 0,
  method = "value",
  ncore = 1,
  pop.cov = NULL,
  mu = NULL,
  varnames = c("x", "w", "m", "xw", "mw", "y")
)
}
\arguments{
\item{c1}{regression coefficient of outcome (m) on moderator (w)}

\item{a1}{regression coefficient of mediator (m) on predictor (x)}

\item{c2}{regression coefficient of outcome (m) on the product (xw)}

\item{d1}{regression coefficient of outcome (y) on moderator (w)}

\item{b1}{regression coefficient of outcome (y) on mediator (m)}

\item{b2}{regression coefficient of outcome (y) on the product (mw)}

\item{cp}{regression coefficient of outcome (y) on predictor (x)}

\item{sigx2}{variance of predictor (x)}

\item{sigw2}{variance of moderator (w)}

\item{sige12}{variance of error in the first regression equation}

\item{sige22}{variance of error in the second regression equation}

\item{sigx_w}{covariance between predictor (x) and moderator (w)}

\item{n}{sample size}

\item{nrep}{number of replications}

\item{alpha}{type 1 error rate}

\item{b}{number of bootstrap iterations}

\item{nb}{bootstrap sample size, default to n}

\item{w_value}{moderator level}

\item{method}{"value" for using the indirect effect value in power calculation, or "joint" for using joint significance in power calculation}

\item{ncore}{number of cores to use, default is 1, when ncore > 1, parallel is used}

\item{pop.cov}{covariance matrix, default to NULL if using the regression coefficient approach}

\item{mu}{mean vector, default to NULL if using the regression coefficient approach}

\item{varnames}{name of variables for the covariance matrix}
}
\value{
power of indirect effect, direct effect, and moderation
}
\description{
power analysis of model 58 in Introduction to Mediation, Moderation, and Conditional Process Analysis
}
\examples{
\donttest{
test = wp.modmed.m58(c1 = 0.2, a1 = 0.2, c2 = 0.1, b2 = 0.1,
     b1 = 0.2, cp = 0.2, d1 = 0.2,
     sigx2 = 1, sigw2 = 1, sige12 = 1, sige22 = 1, sigx_w = 0.5,
     n = 50, nrep = 100, alpha = 0.05, b = 1000, ncore = 1)
print(test)
}
}
