\name{MLEcontour}

\alias{MLEcontour}

\title{Likelihood Ratio Contour for Weibull and Lognormal Fitted Data}

\description{
\code{MLEcontour} This function generates points for a display of the likelihood contour at given confidence limit
  for the 2-parameter Weibull or lognormal distributions.
}

\usage{
MLEcontour(x,  dist="weibull", CL=0.9,dof=1,MLEfit=NULL, RadLimit=1e-5,
             ptDensity=120, debias="none", show=FALSE)
}

\arguments{
  \item{x}{A dataframe such as generated by mleframe with column names 'left', 'right' and optionally 'qty'.
    Exact failure data (occurrences) have same time entered in both 'left' and 'right' columns.
    Suspension data has last known life[time] entered in 'left' column and -1 entered in 'right' column.
    The left(early) interval bound for left-censored data must be entered as zero. (NA is not accepted).
  }
  \item{dist}{A string defining a distribution to be fit. Implemented distributions are "weibull" (default) and "lognormal".
  }
  \item{CL}{a confidence limit to be applied to the Chi square test.}
  \item{dof}{an integer value indicating degrees of freedom to apply to the Chi square test, which defaults to dof=1 for
  confidence interval bound use. Should be set to 2 for comparison of two models each with 2 parameters.}
  \item{MLEfit}{an optional argument to use a fit made external to the function. Disaster awaits any mismatch between data
  entered and this fit. When provided, the MLEfit} shall be a vector in the order of scale(or logmean), shape (or std dev) and Loglikelihood.
  \item{ptDensity}{an integer value for the number of points to be plotted around the circumference of the contour.}
  \item{RadLimit}{a convergence limit for the contour radials based on specific units of Eta/Eta_hat and Beta/Beta_hat.}
  \item{debias}{An optional string argument indicating the adjustment to be applied to the shape or standard deviation
  parameter of the fitted data. Recognized values are "rba", "mean", or "hrbu".
  }
  \item{show}{a logical value indicating whether a graphical output is desired (independent of wblr activity).}
}

\value{
   A dataframe of plotting points for the contour.
}

\details{
   The contour points (p1,p2) identified as satisfying the root of the equation,
   (log(ML(p1_hat,p2_hat))-log(RL(p1,p2)) - chisquare(CL,DF)/2=0,where ML is Maximum Likelihood for the data,and RL
   is Ratioed Likelihood for the data at selected points for the contour.
   The algorithm for this function (executed in compiled C++ code) uses a quinary search for the root optimization of each radial
   on a polar coordinate loop. It is believed to be unique from commercial implementations and appears to have improved stability
   for this notoriously challenging calculation.
}

\references{
  William Q. Meeker and Luis A. Escobar, (1998) "Statistical Methods for Reliability Data", Wiley-Interscience, New York

   Robert B. Abernethy, (2008) "The New Weibull Handbook, Fifth Edition"
  
   John I. McCool, (2012) "Using the Weibull Distribution: Reliability, Modeling and Inference"
}

\examples{
fig3cF<-c(1500,2250,4000,4300,7000)
fig3cS<-c(1750,5000)
Contour<-MLEcontour(mleframe(fig3cF,fig3cS))
}

\keyword{ likelihood }