% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WienerDist.R
\name{WienerCDF}
\alias{WienerCDF}
\title{First-passage time cumulative distribution function of the diffusion model}
\usage{
WienerCDF(
  t,
  response,
  a,
  v,
  w,
  t0 = 0,
  sv = 0,
  sw = 0,
  st0 = 0,
  precision = NULL,
  K = NULL,
  n.threads = FALSE,
  n.evals = 6000
)
}
\arguments{
\item{t}{First-passage time. Numeric vector.}

\item{response}{Response boundary. Character vector with \code{"upper"} and \code{"lower"} as possible values. Alternatively a numeric vector with
\code{1}=lower and \code{2}=upper.}

\item{a}{Upper barrier. Numeric vector.}

\item{v}{Drift rate. Numeric vector.}

\item{w}{Relative starting point. Numeric vector.}

\item{t0}{Non-decision time. Numeric vector}

\item{sv}{Inter-trial variability of drift rate. Numeric vector. Standard deviation of a normal distribution \code{N(v, sv)}.}

\item{sw}{Inter-trial variability of relative starting point. Numeric vector. Range of uniform distribution \code{U(w-0.5*sw, w+0.5*sw)}.}

\item{st0}{Inter-trial variability of non-decision time. Numeric vector. Range of uniform distribution \code{U(t0, t0+st0)}.}

\item{precision}{Optional numeric value. Precision of the CDF. Numeric value. Default is \code{NULL}, which takes default value 1e-12.}

\item{K}{Optional. Number of iterations to calculate the infinite sums. Numeric value (integer). Default is \code{NULL}.
\itemize{
  \item \code{precision = NULL} and \code{K = NULL}: Default \code{precision = 1e-12} used to calculate internal K.
  \item \code{precision != NULL} and \code{K = NULL}: \code{precision} is used to calculate internal K,
  \item \code{precision = NULL} and \code{K != NULL}: \code{K} is used as internal K,
  \item \code{precision != NULL} and \code{K != NULL}: if internal K calculated through \code{precision} is smaller than \code{K}, \code{K} is used.
}
We recommend using either default (\code{precision = K = NULL}) or only \code{precision}.}

\item{n.threads}{Optional numerical or logical value. Number of threads to use. If not provided (or 1 or \code{FALSE}) parallelization is not used. If set to \code{TRUE} then all available threads are used.}

\item{n.evals}{Optional. Number of maximal function evaluations in the numeric integral if sv, sw, and/or st0 are not zero. Default is \code{6000} and \code{0} implies no limit and the 
numeric integration goes on until the specified \code{precision} is guaranteed.}
}
\value{
A list of the class \code{Diffusion_cdf} containing
  \itemize{
    \item \code{cdf}: the CDF,
    \item \code{logcdf}: the log-transformed CDF,
    \item \code{call}: the function call,
    \item \code{err}: the absolute error. Only provided if sv, sw, or st0 is non-zero. If numerical integration is used, the precision cannot always be guaranteed.
  }
}
\description{
Calculates the first-passage time cumulative distribution function of the diffusion model.
}
\examples{
WienerCDF(t = 1.2, response = "upper", a = 1.1, v = 13, w = .6, precision = NULL, K = NULL)
}
\references{
Blurton, S. P., Kesselmeier, M., & Gondan, M. (2012). Fast and accurate calculations for cumulative first-passage time distributions in Wiener diffusion models. \emph{Journal of Mathematical Psychology, 56(6)}, 470–475. \doi{10.1016/j.jmp.2012.09.002}

Gondan, M., Blurton, S. P., & Kesselmeier, M. (2014). Even faster and even more accurate first-passage time densities and distributions for the Wiener diffusion model. \emph{Journal of Mathematical Psychology, 60}, 20–22. \doi{10.1016/j.jmp.2014.05.002}

Hartmann, R., & Klauer, K. C. (2021). Partial derivatives for the first-passage time distribution in Wiener diffusion models. \emph{Journal of Mathematical Psychology, 103}, 102550. \doi{10.1016/j.jmp.2021.102550}
}
\author{
Raphael Hartmann
}
