% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_simulation.r
\name{simbase_labeler}
\alias{simbase_labeler}
\title{Default labelling function for simbase objects}
\usage{
simbase_labeler(data, simbase_class, transforms)
}
\arguments{
\item{data}{The dataset for the calculation of the basic simulation data.}

\item{simbase_class}{The class of the simbase object for which the label is
to be generated. Currently, only \code{"simbase_covar"} is supported.}

\item{transforms}{The transforms applied to variables in the dataset.
Must be objects of class \code{trans} or class \code{transform}
(see function \code{trans_new} in package \code{scales}).}
}
\value{
A string for labelling a simbase object.
}
\description{
Each simbase object should have a label which can be used for differentiating
different simulations. This function tries to simplify the label generation.
}
\details{
Primarily, this function is intended to be called as a default from
\code{\link{simbase_covar}}. It can also serve as a template for creating
custom labelling functions.
}
