% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Computation.r
\name{computeRoundDemand}
\alias{computeRoundDemand}
\title{Computes the expected demand per round}
\usage{
computeRoundDemand(campaign, price, round, previousRounds = TRUE)
}
\arguments{
\item{campaign}{Word-of-Mouth campaign as instance of class \code{WoMCampaign}.}

\item{price}{Price as number in [0; 1] where 0 is the minimal and 1 is the maximal price.}

\item{round}{Round at which or until which the demand per round will be computed.}

\item{previousRounds}{Should the demand of all previous rounds be returned or not. Default is TRUE.}
}
\value{
Expected demand in number of persons. Note that the first value in the demand vector is the number of initial consumers 
when previousRounds is TRUE. The number of initial consumers is (1-p)*seedingSize.
}
\description{
Computes the expected demand for a given Word-of-Mouth campaign at a given price and a given round or a given round and all previous rounds
}
\examples{

network <- new("WoMNetwork", size = 1000, avgConnections = 5)
campaign <- new("WoMCampaign", network = network, seedingSize = 10, forwardProbability = 0.2)
demand <- computeRoundDemand(campaign, price = 0.5, round = 3)
print(demand)

}
\seealso{
\code{\link{computeDemand}} \code{\link{computeProfit}} \code{\link{computeConsumerSurplus}} \code{\link{computeOptimalPrice}}
}
\author{
Michael Scholz \email{michael.scholz@th-deg.de}

Thomas Woehner \email{Thomas.Woehner@eah-jena.de}

Ralf Peters \email{ralf.peters@wiwi.uni-halle.de}
}
