% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xSM2DF.r
\name{xSM2DF}
\alias{xSM2DF}
\title{Function to create a data frame (with three columns) from a (sparse) matrix}
\usage{
xSM2DF(data, verbose = TRUE)
}
\arguments{
\item{data}{a matrix or an object of the dgCMatrix class (a sparse
matrix)}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to TRUE for display}
}
\value{
a data frame containing three columns: 1st column for row names, 2nd
for column names, and 3rd for numeric values
}
\description{
\code{xSM2DF} is supposed to create a data frame (with three columns)
from a (sparse) matrix. Only nonzero entries from the matrix will be
kept in the resulting data frame.
}
\note{
none
None
}
\examples{
# create a sparse matrix of 4 X 2
input.file <- rbind(c('R1','C1',1), c('R2','C1',1), c('R2','C2',1),
c('R3','C2',2), c('R4','C1',1))
data <- xSparseMatrix(input.file)
# convert into a data frame a full matrix
res_df <- xSM2DF(data)
res_df
}
\seealso{
\code{\link{xSM2DF}}
}

