% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xCombineNet.r
\name{xCombineNet}
\alias{xCombineNet}
\title{Function to combine networks from a list of igraph objects}
\usage{
xCombineNet(
list_ig,
combineBy = c("union", "intersect"),
attrBy = c("intersect", "union"),
keep.all.vertices = FALSE,
verbose = TRUE
)
}
\arguments{
\item{list_ig}{a list of "igraph" objects or a "igraph" object}

\item{combineBy}{how to resolve edges from a list of "igraph" objects.
It can be "intersect" for intersecting edges and "union" for unionising
edges (by default)}

\item{attrBy}{the method used to extract node attributes. It can be
"intersect" for intersecting node attributes (by default) and "union"
for unionising node attributes}

\item{keep.all.vertices}{logical to indicate whether all nodes are kept
when intersecting edges. By default, it sets to false}

\item{verbose}{logical to indicate whether the messages will be
displayed in the screen. By default, it sets to true for display}
}
\value{
an object of class "igraph"
}
\description{
\code{xCombineNet} is supposed to combine networks from a list of
igraph objects.
}
\note{
none
}
\examples{
\dontrun{
# Load the library
library(XGR)
}

RData.location <- "http://galahad.well.ox.ac.uk/bigdata"
\dontrun{
g1 <- xDefineNet(network="KEGG_environmental",
RData.location=RData.location)
g2 <- xDefineNet(network="KEGG_organismal",
RData.location=RData.location)
ls_ig <- list(g1, g2)
ig <- xCombineNet(ls_ig, combineBy='union', attrBy="intersect",
verbose=TRUE)
}
}
\seealso{
\code{\link{xDefineNet}}
}
