% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xEnrichGGraph.r
\name{xEnrichGGraph}
\alias{xEnrichGGraph}
\title{Function to visualise enrichment results using a ggraph-like lauout}
\usage{
xEnrichGGraph(
eTerm,
ig = NULL,
fixed = T,
node.color = c("zscore", "adjp", "or"),
colormap = "grey-orange-darkred",
zlim = NULL,
node.size = c("adjp", "zscore", "or"),
slim = NULL,
node.size.range = c(0.5, 4),
node.label.size = 2,
leave = T,
ncolumns = NULL,
...
)
}
\arguments{
\item{eTerm}{an object of class "eTerm" or "ls_eTerm". Alterntively, it
can be a data frame having all these columns
('name','adjp','or','zscore'; 'group' optionally)}

\item{ig}{an object of class "igraph" with node attribute 'name'. Note:
the node labels would be the node attribute 'name' unless the node
attribute 'label' is explicitely provided. If provided, only those
terms within it will be visualised. By default, it is NULL meaning no
surch restriction}

\item{fixed}{logical to indicate whether all terms in ig will be
visualised. By default, it is TURE; otherwise only overlapped terms
from eTerm will be visualised}

\item{node.color}{which statistics will be used for node coloring. It
can be "or" for the odds ratio, "adjp" for adjusted p value (FDR) and
"zscore" for enrichment z-score}

\item{colormap}{short name for the colormap. It can be one of "jet"
(jet colormap), "bwr" (blue-white-red colormap), "gbr" (green-black-red
colormap), "wyr" (white-yellow-red colormap), "br" (black-red
colormap), "yr" (yellow-red colormap), "wb" (white-black colormap),
"rainbow" (rainbow colormap, that is,
red-yellow-green-cyan-blue-magenta), and "ggplot2" (emulating ggplot2
default color palette). Alternatively, any hyphen-separated HTML color
names, e.g. "lightyellow-orange" (by default), "blue-black-yellow",
"royalblue-white-sandybrown", "darkgreen-white-darkviolet". A list of
standard color names can be found in
\url{http://html-color-codes.info/color-names}}

\item{zlim}{the minimum and maximum values for which colors should be
plotted}

\item{node.size}{which statistics will be used for node size. It can be
"or" for the odds ratio, "adjp" for adjusted p value (FDR) and "zscore"
for enrichment z-score}

\item{slim}{the minimum and maximum values for which sizes should be
plotted}

\item{node.size.range}{the range of actual node size}

\item{node.label.size}{the text size of the node labelings. By default,
it is 2. If 0, all labellings will be disabled}

\item{leave}{the logic specifying whether or not only leaves
(nodes/labellings) shown. This can be disenabled if the layout does not
support tips}

\item{ncolumns}{an integer specifying the number of columns for
facet_wrap. By defaul, it is NULL (decided on according to the number
of groups that will be visualised)}

\item{...}{additional graphic parameters used in xGGraph}
}
\value{
a ggplot2 object appended with 'ig', 'data' which should contain
columns 'x','y', 'name' (the same as V(ig)$name), 'label' (if not given
in ig, a 'name' varient), 'data_enrichment' (enrichment results), and
'gp_template' with labelling if multiple groups (together with no
labelling for the colored plots).
}
\description{
\code{xEnrichGGraph} is supposed to visualise enrichment results using
a ggraph-like lauout.
}
\note{
none
}
\examples{
\dontrun{
# Load the XGR package and specify the location of built-in data
library(XGR)
RData.location <- "http://galahad.well.ox.ac.uk/bigdata"

# load the atlas of AA pathways
AA.template <- xRDataLoader("AA.template",
RData.location=RData.location)
# consensus tree
ig <- AA.template$consensus$ig

# enrichment analysis using AA pathways
input <- xRDataLoader('Haploid_regulators_all',
RData.location=RData.location)
data <- subset(input, Phenotype=="AKT")
genes <- data$Gene[data$FDR<0.05]
background <- data$Gene
eTerm <- xEnricherGenes(genes, background=background, ontology="AA",
min.overlap=5, test="fisher", RData.location=RData.location)

# circular visualisation of enriched AA pathways
gp <- xEnrichGGraph(eTerm, ig)

###############################
# advanced use: multiple groups
# enrichment analysis using AA pathways
Haploid <- subset(input, FDR<0.05)
ls_group <- split(x=Haploid$Gene, f=Haploid$Phenotype)
background <- unique(input$Gene)
ls_eTerm <- xEnricherGenesAdv(ls_group, background=background,
ontologies="AA", test="fisher", min.overlap=5,
RData.location=RData.location)

# circular visualisation of enriched AA pathways
gp <- xEnrichGGraph(ls_eTerm, ig)
gp
gp$gp_template
}
}
\seealso{
\code{\link{xGGraph}}
}
