/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.formula.ConditionalFormattingEvaluator;
import org.apache.poi.ss.formula.DataValidationEvaluator;
import org.apache.poi.ss.formula.WorkbookEvaluator;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.BoolEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.AggregateFunction;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ConditionFilterData;
import org.apache.poi.ss.usermodel.ConditionFilterType;
import org.apache.poi.ss.usermodel.ConditionType;
import org.apache.poi.ss.usermodel.ConditionalFormatting;
import org.apache.poi.ss.usermodel.ConditionalFormattingRule;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class EvaluationConditionalFormatRule
implements Comparable<EvaluationConditionalFormatRule> {
    private final WorkbookEvaluator workbookEvaluator;
    private final Sheet sheet;
    private final ConditionalFormatting formatting;
    private final ConditionalFormattingRule rule;
    private final CellRangeAddress[] regions;
    private final Map<CellRangeAddress, Set<ValueAndFormat>> meaningfulRegionValues = new HashMap<CellRangeAddress, Set<ValueAndFormat>>();
    private final int priority;
    private final int formattingIndex;
    private final int ruleIndex;
    private final String formula1;
    private final String formula2;
    private final OperatorEnum operator;
    private final ConditionType type;

    public EvaluationConditionalFormatRule(WorkbookEvaluator workbookEvaluator, Sheet sheet, ConditionalFormatting formatting, int formattingIndex, ConditionalFormattingRule rule, int ruleIndex, CellRangeAddress[] regions) {
        this.workbookEvaluator = workbookEvaluator;
        this.sheet = sheet;
        this.formatting = formatting;
        this.rule = rule;
        this.formattingIndex = formattingIndex;
        this.ruleIndex = ruleIndex;
        this.priority = rule.getPriority();
        this.regions = regions;
        this.formula1 = rule.getFormula1();
        this.formula2 = rule.getFormula2();
        this.operator = OperatorEnum.values()[rule.getComparisonOperation()];
        this.type = rule.getConditionType();
    }

    public Sheet getSheet() {
        return this.sheet;
    }

    public ConditionalFormatting getFormatting() {
        return this.formatting;
    }

    public int getFormattingIndex() {
        return this.formattingIndex;
    }

    public ConditionalFormattingRule getRule() {
        return this.rule;
    }

    public int getRuleIndex() {
        return this.ruleIndex;
    }

    public CellRangeAddress[] getRegions() {
        return this.regions;
    }

    public int getPriority() {
        return this.priority;
    }

    public String getFormula1() {
        return this.formula1;
    }

    public String getFormula2() {
        return this.formula2;
    }

    public OperatorEnum getOperator() {
        return this.operator;
    }

    public ConditionType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        EvaluationConditionalFormatRule r = (EvaluationConditionalFormatRule)obj;
        return this.getSheet().getSheetName().equalsIgnoreCase(r.getSheet().getSheetName()) && this.getFormattingIndex() == r.getFormattingIndex() && this.getRuleIndex() == r.getRuleIndex();
    }

    @Override
    public int compareTo(EvaluationConditionalFormatRule o) {
        int y;
        int cmp = this.getSheet().getSheetName().compareToIgnoreCase(o.getSheet().getSheetName());
        if (cmp != 0) {
            return cmp;
        }
        int x = this.getPriority();
        int n = x < (y = o.getPriority()) ? -1 : (cmp = x == y ? 0 : 1);
        if (cmp != 0) {
            return cmp;
        }
        cmp = new Integer(this.getFormattingIndex()).compareTo(new Integer(o.getFormattingIndex()));
        if (cmp != 0) {
            return cmp;
        }
        return new Integer(this.getRuleIndex()).compareTo(new Integer(o.getRuleIndex()));
    }

    public int hashCode() {
        int hash = this.sheet.getSheetName().hashCode();
        hash = 31 * hash + this.formattingIndex;
        hash = 31 * hash + this.ruleIndex;
        return hash;
    }

    boolean matches(Cell cell) {
        CellRangeAddress region = null;
        for (CellRangeAddress r : this.regions) {
            if (!r.isInRange(cell)) continue;
            region = r;
            break;
        }
        if (region == null) {
            return false;
        }
        ConditionType ruleType = this.getRule().getConditionType();
        if (ruleType.equals(ConditionType.COLOR_SCALE) || ruleType.equals(ConditionType.DATA_BAR) || ruleType.equals(ConditionType.ICON_SET)) {
            return true;
        }
        if (ruleType.equals(ConditionType.CELL_VALUE_IS)) {
            return this.checkValue(cell, region);
        }
        if (ruleType.equals(ConditionType.FORMULA)) {
            return this.checkFormula(cell, region);
        }
        if (ruleType.equals(ConditionType.FILTER)) {
            return this.checkFilter(cell, region);
        }
        return false;
    }

    private boolean checkValue(Cell cell, CellRangeAddress region) {
        if (cell == null || DataValidationEvaluator.isType(cell, CellType.BLANK) || DataValidationEvaluator.isType(cell, CellType.ERROR) || DataValidationEvaluator.isType(cell, CellType.STRING) && (cell.getStringCellValue() == null || cell.getStringCellValue().isEmpty())) {
            return false;
        }
        ValueEval eval = this.unwrapEval(this.workbookEvaluator.evaluate(this.rule.getFormula1(), ConditionalFormattingEvaluator.getRef(cell), region));
        String f2 = this.rule.getFormula2();
        ValueEval eval2 = null;
        if (f2 != null && f2.length() > 0) {
            eval2 = this.unwrapEval(this.workbookEvaluator.evaluate(f2, ConditionalFormattingEvaluator.getRef(cell), region));
        }
        if (DataValidationEvaluator.isType(cell, CellType.BOOLEAN)) {
            if (eval instanceof BoolEval && (eval2 == null || eval2 instanceof BoolEval)) {
                return this.operator.isValid(cell.getBooleanCellValue(), ((BoolEval)eval).getBooleanValue(), eval2 == null ? null : Boolean.valueOf(((BoolEval)eval2).getBooleanValue()));
            }
            return false;
        }
        if (DataValidationEvaluator.isType(cell, CellType.NUMERIC)) {
            if (eval instanceof NumberEval && (eval2 == null || eval2 instanceof NumberEval)) {
                return this.operator.isValid(cell.getNumericCellValue(), ((NumberEval)eval).getNumberValue(), eval2 == null ? null : Double.valueOf(((NumberEval)eval2).getNumberValue()));
            }
            return false;
        }
        if (DataValidationEvaluator.isType(cell, CellType.STRING)) {
            if (eval instanceof StringEval && (eval2 == null || eval2 instanceof StringEval)) {
                return this.operator.isValid(cell.getStringCellValue(), ((StringEval)eval).getStringValue(), eval2 == null ? null : ((StringEval)eval2).getStringValue());
            }
            return false;
        }
        return false;
    }

    private ValueEval unwrapEval(ValueEval eval) {
        ValueEval comp = eval;
        while (comp instanceof RefEval) {
            RefEval ref = (RefEval)comp;
            comp = ref.getInnerValueEval(ref.getFirstSheetIndex());
        }
        return comp;
    }

    private boolean checkFormula(Cell cell, CellRangeAddress region) {
        ValueEval comp = this.unwrapEval(this.workbookEvaluator.evaluate(this.rule.getFormula1(), ConditionalFormattingEvaluator.getRef(cell), region));
        if (comp instanceof BlankEval) {
            return true;
        }
        if (comp instanceof ErrorEval) {
            return false;
        }
        if (comp instanceof BoolEval) {
            return ((BoolEval)comp).getBooleanValue();
        }
        if (comp instanceof NumberEval) {
            return ((NumberEval)comp).getNumberValue() != 0.0;
        }
        return false;
    }

    private boolean checkFilter(Cell cell, CellRangeAddress region) {
        ConditionFilterType filterType = this.rule.getConditionFilterType();
        if (filterType == null) {
            return false;
        }
        switch (filterType) {
            case FILTER: {
                return false;
            }
            case TOP_10: {
                ValueAndFormat cv10 = this.getCellValue(cell);
                if (!cv10.isNumber()) {
                    return false;
                }
                return this.getMeaningfulValues(region, false, new ValueFunction(){

                    @Override
                    public Set<ValueAndFormat> evaluate(List<ValueAndFormat> allValues) {
                        List<ValueAndFormat> values = allValues;
                        ConditionFilterData conf = EvaluationConditionalFormatRule.this.rule.getFilterConfiguration();
                        if (!conf.getBottom()) {
                            Collections.sort(values, Collections.reverseOrder());
                        } else {
                            Collections.sort(values);
                        }
                        int limit = (int)conf.getRank();
                        if (conf.getPercent()) {
                            limit = allValues.size() * limit / 100;
                        }
                        if (allValues.size() <= limit) {
                            return new HashSet<ValueAndFormat>(allValues);
                        }
                        return new HashSet<ValueAndFormat>(allValues.subList(0, limit));
                    }
                }).contains(cv10);
            }
            case UNIQUE_VALUES: {
                return this.getMeaningfulValues(region, true, new ValueFunction(){

                    @Override
                    public Set<ValueAndFormat> evaluate(List<ValueAndFormat> allValues) {
                        List<ValueAndFormat> values = allValues;
                        Collections.sort(values);
                        HashSet<ValueAndFormat> unique = new HashSet<ValueAndFormat>();
                        for (int i = 0; i < values.size(); ++i) {
                            ValueAndFormat v = values.get(i);
                            if (i < values.size() - 1 && v.equals(values.get(i + 1)) || i > 0 && i == values.size() - 1 && v.equals(values.get(i - 1))) {
                                ++i;
                                continue;
                            }
                            unique.add(v);
                        }
                        return unique;
                    }
                }).contains(this.getCellValue(cell));
            }
            case DUPLICATE_VALUES: {
                return this.getMeaningfulValues(region, true, new ValueFunction(){

                    @Override
                    public Set<ValueAndFormat> evaluate(List<ValueAndFormat> allValues) {
                        List<ValueAndFormat> values = allValues;
                        Collections.sort(values);
                        HashSet<ValueAndFormat> dup = new HashSet<ValueAndFormat>();
                        for (int i = 0; i < values.size(); ++i) {
                            ValueAndFormat v = values.get(i);
                            if ((i >= values.size() - 1 || !v.equals(values.get(i + 1))) && (i <= 0 || i != values.size() - 1 || !v.equals(values.get(i - 1)))) continue;
                            dup.add(v);
                            ++i;
                        }
                        return dup;
                    }
                }).contains(this.getCellValue(cell));
            }
            case ABOVE_AVERAGE: {
                Double val;
                ConditionFilterData conf = this.rule.getFilterConfiguration();
                ArrayList<ValueAndFormat> values = new ArrayList<ValueAndFormat>(this.getMeaningfulValues(region, false, new ValueFunction(){

                    @Override
                    public Set<ValueAndFormat> evaluate(List<ValueAndFormat> allValues) {
                        List<ValueAndFormat> values = allValues;
                        double total = 0.0;
                        ValueEval[] pop = new ValueEval[values.size()];
                        for (int i = 0; i < values.size(); ++i) {
                            ValueAndFormat v = values.get(i);
                            total += v.value.doubleValue();
                            pop[i] = new NumberEval(v.value);
                        }
                        LinkedHashSet<ValueAndFormat> avgSet = new LinkedHashSet<ValueAndFormat>(1);
                        avgSet.add(new ValueAndFormat(new Double(values.size() == 0 ? 0.0 : total / (double)values.size()), null));
                        double stdDev = values.size() <= 1 ? 0.0 : ((NumberEval)AggregateFunction.STDEV.evaluate(pop, 0, 0)).getNumberValue();
                        avgSet.add(new ValueAndFormat(new Double(stdDev), null));
                        return avgSet;
                    }
                }));
                ValueAndFormat cv = this.getCellValue(cell);
                Double d = val = cv.isNumber() ? cv.getValue() : null;
                if (val == null) {
                    return false;
                }
                double avg = ((ValueAndFormat)values.get(0)).value;
                double stdDev = ((ValueAndFormat)values.get(1)).value;
                Double comp = new Double(conf.getStdDev() > 0 ? avg + (double)(conf.getAboveAverage() ? 1 : -1) * stdDev * (double)conf.getStdDev() : avg);
                OperatorEnum op = null;
                op = conf.getAboveAverage() ? (conf.getEqualAverage() ? OperatorEnum.GREATER_OR_EQUAL : OperatorEnum.GREATER_THAN) : (conf.getEqualAverage() ? OperatorEnum.LESS_OR_EQUAL : OperatorEnum.LESS_THAN);
                return op != null && op.isValid(val, comp, null);
            }
            case CONTAINS_TEXT: {
                return this.checkFormula(cell, region);
            }
            case NOT_CONTAINS_TEXT: {
                return this.checkFormula(cell, region);
            }
            case BEGINS_WITH: {
                return this.checkFormula(cell, region);
            }
            case ENDS_WITH: {
                return this.checkFormula(cell, region);
            }
            case CONTAINS_BLANKS: {
                try {
                    String v = cell.getStringCellValue();
                    return v == null || v.trim().length() == 0;
                }
                catch (Exception e) {
                    return false;
                }
            }
            case NOT_CONTAINS_BLANKS: {
                try {
                    String v = cell.getStringCellValue();
                    return v != null && v.trim().length() > 0;
                }
                catch (Exception e) {
                    return true;
                }
            }
            case CONTAINS_ERRORS: {
                return cell != null && DataValidationEvaluator.isType(cell, CellType.ERROR);
            }
            case NOT_CONTAINS_ERRORS: {
                return cell == null || !DataValidationEvaluator.isType(cell, CellType.ERROR);
            }
            case TIME_PERIOD: {
                return this.checkFormula(cell, region);
            }
        }
        return false;
    }

    private Set<ValueAndFormat> getMeaningfulValues(CellRangeAddress region, boolean withText, ValueFunction func) {
        Set<ValueAndFormat> values = this.meaningfulRegionValues.get(region);
        if (values != null) {
            return values;
        }
        ArrayList<ValueAndFormat> allValues = new ArrayList<ValueAndFormat>((region.getLastColumn() - region.getFirstColumn() + 1) * (region.getLastRow() - region.getFirstRow() + 1));
        for (int r = region.getFirstRow(); r <= region.getLastRow(); ++r) {
            Row row = this.sheet.getRow(r);
            if (row == null) continue;
            for (int c = region.getFirstColumn(); c <= region.getLastColumn(); ++c) {
                Cell cell = row.getCell(c);
                ValueAndFormat cv = this.getCellValue(cell);
                if (cv == null || !withText && !cv.isNumber()) continue;
                allValues.add(cv);
            }
        }
        values = func.evaluate(allValues);
        this.meaningfulRegionValues.put(region, values);
        return values;
    }

    private ValueAndFormat getCellValue(Cell cell) {
        if (cell != null) {
            CellType type = cell.getCellTypeEnum();
            if (type == CellType.NUMERIC || type == CellType.FORMULA && cell.getCachedFormulaResultTypeEnum() == CellType.NUMERIC) {
                return new ValueAndFormat(new Double(cell.getNumericCellValue()), cell.getCellStyle().getDataFormatString());
            }
            if (type == CellType.STRING || type == CellType.FORMULA && cell.getCachedFormulaResultTypeEnum() == CellType.STRING) {
                return new ValueAndFormat(cell.getStringCellValue(), cell.getCellStyle().getDataFormatString());
            }
            if (type == CellType.BOOLEAN || type == CellType.FORMULA && cell.getCachedFormulaResultTypeEnum() == CellType.BOOLEAN) {
                return new ValueAndFormat(cell.getStringCellValue(), cell.getCellStyle().getDataFormatString());
            }
        }
        return null;
    }

    protected class ValueAndFormat
    implements Comparable<ValueAndFormat> {
        private final Double value;
        private final String string;
        private final String format;

        public ValueAndFormat(Double value, String format) {
            this.value = value;
            this.format = format;
            this.string = null;
        }

        public ValueAndFormat(String value, String format) {
            this.value = null;
            this.format = format;
            this.string = value;
        }

        public boolean isNumber() {
            return this.value != null;
        }

        public Double getValue() {
            return this.value;
        }

        public boolean equals(Object obj) {
            ValueAndFormat o = (ValueAndFormat)obj;
            return !(this.value != o.value && !this.value.equals(o.value) || this.format != o.format && !this.format.equals(o.format) || this.string != o.string && !this.string.equals(o.string));
        }

        @Override
        public int compareTo(ValueAndFormat o) {
            int cmp;
            if (this.value == null && o.value != null) {
                return 1;
            }
            if (o.value == null && this.value != null) {
                return -1;
            }
            int n = cmp = this.value == null ? 0 : this.value.compareTo(o.value);
            if (cmp != 0) {
                return cmp;
            }
            if (this.string == null && o.string != null) {
                return 1;
            }
            if (o.string == null && this.string != null) {
                return -1;
            }
            return this.string == null ? 0 : this.string.compareTo(o.string);
        }

        public int hashCode() {
            return (this.string == null ? 0 : this.string.hashCode()) * 37 * 37 + 37 * (this.value == null ? 0 : this.value.hashCode()) + (this.format == null ? 0 : this.format.hashCode());
        }
    }

    public static enum OperatorEnum {
        NO_COMPARISON{

            @Override
            public <C extends Comparable<C>> boolean isValid(C cellValue, C v1, C v2) {
                return false;
            }
        }
        ,
        BETWEEN{

            @Override
            public <C extends Comparable<C>> boolean isValid(C cellValue, C v1, C v2) {
                return cellValue.compareTo(v1) >= 0 && cellValue.compareTo(v2) <= 0;
            }
        }
        ,
        NOT_BETWEEN{

            @Override
            public <C extends Comparable<C>> boolean isValid(C cellValue, C v1, C v2) {
                return cellValue.compareTo(v1) < 0 || cellValue.compareTo(v2) > 0;
            }
        }
        ,
        EQUAL{

            @Override
            public <C extends Comparable<C>> boolean isValid(C cellValue, C v1, C v2) {
                if (cellValue.getClass() == String.class) {
                    return cellValue.toString().compareToIgnoreCase(v1.toString()) == 0;
                }
                return cellValue.compareTo(v1) == 0;
            }
        }
        ,
        NOT_EQUAL{

            @Override
            public <C extends Comparable<C>> boolean isValid(C cellValue, C v1, C v2) {
                if (cellValue.getClass() == String.class) {
                    return cellValue.toString().compareToIgnoreCase(v1.toString()) == 0;
                }
                return cellValue.compareTo(v1) != 0;
            }
        }
        ,
        GREATER_THAN{

            @Override
            public <C extends Comparable<C>> boolean isValid(C cellValue, C v1, C v2) {
                return cellValue.compareTo(v1) > 0;
            }
        }
        ,
        LESS_THAN{

            @Override
            public <C extends Comparable<C>> boolean isValid(C cellValue, C v1, C v2) {
                return cellValue.compareTo(v1) < 0;
            }
        }
        ,
        GREATER_OR_EQUAL{

            @Override
            public <C extends Comparable<C>> boolean isValid(C cellValue, C v1, C v2) {
                return cellValue.compareTo(v1) >= 0;
            }
        }
        ,
        LESS_OR_EQUAL{

            @Override
            public <C extends Comparable<C>> boolean isValid(C cellValue, C v1, C v2) {
                return cellValue.compareTo(v1) <= 0;
            }
        };


        public abstract <C extends Comparable<C>> boolean isValid(C var1, C var2, C var3);
    }

    protected static interface ValueFunction {
        public Set<ValueAndFormat> evaluate(List<ValueAndFormat> var1);
    }
}

