/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.streaming;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FormulaError;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.streaming.SXSSFRow;

public class SheetDataWriter {
    private final File _fd = this.createTempFile();
    private final Writer _out = this.createWriter(this._fd);
    private int _rownum;
    private boolean _rowContainedNullCells = false;
    int _numberOfFlushedRows;
    int _lowestIndexOfFlushedRows;
    int _numberOfCellsOfLastFlushedRow;

    public File createTempFile() throws IOException {
        File fd = File.createTempFile("poi-sxssf-sheet", ".xml");
        fd.deleteOnExit();
        return fd;
    }

    public Writer createWriter(File fd) throws IOException {
        return new BufferedWriter(new FileWriter(fd));
    }

    public void close() throws IOException {
        this._out.flush();
        this._out.close();
    }

    File getTempFile() {
        return this._fd;
    }

    public InputStream getWorksheetXMLInputStream() throws IOException {
        File fd = this.getTempFile();
        return new FileInputStream(fd);
    }

    public int getNumberOfFlushedRows() {
        return this._numberOfFlushedRows;
    }

    public int getNumberOfCellsOfLastFlushedRow() {
        return this._numberOfCellsOfLastFlushedRow;
    }

    public int getLowestIndexOfFlushedRows() {
        return this._lowestIndexOfFlushedRows;
    }

    protected void finalize() throws Throwable {
        this._fd.delete();
    }

    public void writeRow(int rownum, SXSSFRow row) throws IOException {
        if (this._numberOfFlushedRows == 0) {
            this._lowestIndexOfFlushedRows = rownum;
        }
        this._numberOfCellsOfLastFlushedRow = row.getLastCellNum();
        ++this._numberOfFlushedRows;
        this.beginRow(rownum, row);
        Iterator<Cell> cells = row.allCellsIterator();
        int columnIndex = 0;
        while (cells.hasNext()) {
            this.writeCell(columnIndex++, cells.next());
        }
        this.endRow();
    }

    void beginRow(int rownum, SXSSFRow row) throws IOException {
        this._out.write("<row r=\"" + (rownum + 1) + "\"");
        if (row.hasCustomHeight()) {
            this._out.write(" customHeight=\"true\"  ht=\"" + row.getHeightInPoints() + "\"");
        }
        if (row.getZeroHeight()) {
            this._out.write(" hidden=\"true\"");
        }
        if (row.isFormatted()) {
            this._out.write(" s=\"" + row._style + "\"");
            this._out.write(" customFormat=\"1\"");
        }
        this._out.write(">\n");
        this._rownum = rownum;
        this._rowContainedNullCells = false;
    }

    void endRow() throws IOException {
        this._out.write("</row>\n");
    }

    public void writeCell(int columnIndex, Cell cell) throws IOException {
        if (cell == null) {
            this._rowContainedNullCells = true;
            return;
        }
        String ref = new CellReference(this._rownum, columnIndex).formatAsString();
        this._out.write("<c r=\"" + ref + "\"");
        CellStyle cellStyle = cell.getCellStyle();
        if (cellStyle.getIndex() != 0) {
            this._out.write(" s=\"" + cellStyle.getIndex() + "\"");
        }
        int cellType = cell.getCellType();
        switch (cellType) {
            case 3: {
                this._out.write(">");
                break;
            }
            case 2: {
                this._out.write(">");
                this._out.write("<f>");
                this.outputQuotedString(cell.getCellFormula());
                this._out.write("</f>");
                switch (cell.getCachedFormulaResultType()) {
                    case 0: {
                        double nval = cell.getNumericCellValue();
                        if (Double.isNaN(nval)) break;
                        this._out.write("<v>" + nval + "</v>");
                    }
                }
                break;
            }
            case 1: {
                this._out.write(" t=\"inlineStr\">");
                this._out.write("<is><t>");
                this.outputQuotedString(cell.getStringCellValue());
                this._out.write("</t></is>");
                break;
            }
            case 0: {
                this._out.write(" t=\"n\">");
                this._out.write("<v>" + cell.getNumericCellValue() + "</v>");
                break;
            }
            case 4: {
                this._out.write(" t=\"b\">");
                this._out.write("<v>" + (cell.getBooleanCellValue() ? "1" : "0") + "</v>");
                break;
            }
            case 5: {
                FormulaError error = FormulaError.forInt((byte)cell.getErrorCellValue());
                this._out.write(" t=\"e\">");
                this._out.write("<v>" + error.getString() + "</v>");
                break;
            }
            default: {
                assert (false);
                throw new RuntimeException("Huh?");
            }
        }
        this._out.write("</c>");
    }

    protected void outputQuotedString(String s) throws IOException {
        if (s == null || s.length() == 0) {
            return;
        }
        char[] chars = s.toCharArray();
        int last = 0;
        int length = s.length();
        block10: for (int counter = 0; counter < length; ++counter) {
            char c = chars[counter];
            switch (c) {
                case '<': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this._out.write("&lt;");
                    continue block10;
                }
                case '>': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this._out.write("&gt;");
                    continue block10;
                }
                case '&': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this._out.write("&amp;");
                    continue block10;
                }
                case '\"': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this._out.write("&quot;");
                    continue block10;
                }
                case '\n': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    this._out.write("&#xa;");
                    last = counter + 1;
                    continue block10;
                }
                case '\t': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    this._out.write("&#x9;");
                    last = counter + 1;
                    continue block10;
                }
                case '\r': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    this._out.write("&#xd;");
                    last = counter + 1;
                    continue block10;
                }
                case '\u00a0': {
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    this._out.write("&#xa0;");
                    last = counter + 1;
                    continue block10;
                }
                default: {
                    if (c >= ' ' && c <= '\u007f') continue block10;
                    if (counter > last) {
                        this._out.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    this._out.write("&#");
                    this._out.write(String.valueOf((int)c));
                    this._out.write(";");
                }
            }
        }
        if (last < length) {
            this._out.write(chars, last, length - last);
        }
    }
}

