% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RJuliaConnect.R
\name{juliaOptions}
\alias{juliaOptions}
\title{Get and/or Set Internal Option Parameters in the Julia Evaluator}
\usage{
juliaOptions(..., .ev = XRJulia::RJulia())
}
\arguments{
\item{...}{arguments to the corresponding method for an evaluator object.}

\item{.ev}{The evaluator object to use.  By default, and usually, the current evaluator.}
}
\value{
A named list of those parameters requested (as unnamed character string arguments).  If none, an empty list.
Note that options are always returned converted to R, not as proxyies.
}
\description{
The Julia code for an evaluator maintains a dictionary, \code{RJuliaParams}, of named parameters used to control
various evaluation details.  These and any other desired options can be queried and/or set by calls to \code{juliaOptions}.
}
\details{
The function behaves essentially like the \code{\link{options}()} function in R itself, returning a list of the current entries
corresponding to unnamed character arguments and setting the parameters named to the value in the corresponding named argument
to \code{juliaOptions}.
If no parameter corresponding to a name has been set, requesting the corresponding returned value is \code{nothing}, \code{NULL} in R.
}
