% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/classStructure.R
\name{setPythonClass}
\alias{setPythonClass}
\title{Create a Proxy Class for a Python Class}
\usage{
setPythonClass(Class, module = "", fields = character(), methods = NULL,
  ServerClass = Class, where = topenv(parent.frame()),
  contains = character(), proxyObjectClass = "PythonObject", ...,
  example = TRUE)
}
\arguments{
\item{Class}{the Python name for the class.}

\item{module}{the Python module, if this is not a standard library class.}

\item{fields,methods,where,...}{arguments to \code{setProxyClass} and usually omitted.}

\item{ServerClass,contains,proxyObjectClass}{ditto.}

\item{example}{an optional (proxy for) an object from the class, to be used to define the fields in the
class.  If omitted, the interface tries to create a standard object from the class by calling the Python
generator with no argument.  Argument \code{example} can also be supplied as \code{FALSE} to suppress
generating the default object.}
}
\description{
An R class is defined to act as a proxy for a specified Python class.  This specializes the
\code{\link[XR]{setProxyClass}} function using Python facilities for finding the class definition.
}
\details{
The methods and (inferred) fields of a Python Class are determined and returned consistently
with the XR structure.
Python classes are coded as class objects in Python, but only the methods are fixed and defined.
Objects from the class can have any fields, usually created at initialization time but entirely legal
to be added by other methods later.  By default, the initialize method tries to create an object from the
class, with no arguments in the call to the class generator.   Supply the \code{example} argument to
override.
}

