% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sex_stratified_analysis_bulk.R
\name{sex_stratified_analysis_bulk}
\alias{sex_stratified_analysis_bulk}
\title{Perform differential expression analysis within each sex}
\usage{
sex_stratified_analysis_bulk(
  x,
  phenotype,
  gender,
  analysis_type = c("male", "female")
)
}
\arguments{
\item{x}{A numeric matrix of expression data (features × samples).}

\item{phenotype}{A vector indicating condition labels for each sample.}

\item{gender}{A vector indicating gender for each sample. Labels must start with "f" (female) and "m" (male).}

\item{analysis_type}{Character. Type of analysis to perform: "dimorphic" (difference in differences),
"female" (female condition effect), or "male" (male condition effect). Default is "dimorphic".}
}
\value{
A data frame with differential expression statistics including logFC, AveExpr, t-statistic,
        P-value, and adjusted P-value.
}
\description{
This function identifies differentially expressed genes between conditions separately for each sex
using a linear modeling approach.
}
\details{
This function performs differential expression analysis within each sex separately.
         For male analysis, it compares conditions within males.
         For female analysis, it compares conditions within females.
         For dimorphic analysis, it tests for difference in condition effects between sexes.
         Note: To identify truly sex-specific genes, use the output of this function as input
         for identify_sex_specific_genes().
}
