% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_simu.R
\name{data_simu}
\alias{data_simu}
\title{Simulate Time Series Data for ZI-INAR(1) or H-INAR(1) Models}
\usage{
data_simu(n, alpha, rho, lambda, disp = NULL, mod_type, distri)
}
\arguments{
\item{n}{Integer specifying the number of observations to simulate.}

\item{alpha}{Numeric value between 0 and 1 representing the
autoregressive parameter.}

\item{rho}{Numeric value between 0 and 1 representing the zero-inflation
or hurdle parameter.}

\item{lambda}{Numeric value (> 0) representing the location parameter (mean)
for Poisson, or the location parameter for NB and GP distributions.}

\item{disp}{Numeric value representing the dispersion parameter.
\itemize{
\item For \code{"nb"}: Must be positive (> 0).
\item For \code{"gp"}: Must be strictly between 0 and 1 (0 < disp < 1).
\item For \code{"poi"}: Ignored.
}}

\item{mod_type}{Character string indicating the model type ("zi" or "h").}

\item{distri}{Character string specifying the distribution. Options are:
\itemize{
\item \code{"poi"} for Poisson
\item \code{"nb"} for Negative Binomial
\item \code{"gp"} for Generalized Poisson (Only \code{mod_type="zi"} supported)
}}
}
\value{
A numeric vector containing the simulated time series data.
}
\description{
This function simulates time series data for Zero-Inflated INAR(1)
(ZI-INAR(1)) or Hurdle INAR(1) (H-INAR(1)) models, using either Poisson
or Negative Binomial distributions.
}
\examples{
# Simulate 50 observations from a Zero-Inflated Poisson INAR(1) model
y_data <- data_simu(n = 50, alpha = 0.5, rho = 0.3, lambda = 5,
                    mod_type = "zi", distri = "poi")
head(y_data)

}
\references{
Part of the implementation of this function was adapted from the
\strong{ZINAR1} package.
The \strong{ZINAR1} package simulates first-order integer-valued
autoregressive processes
with zero-inflated innovations (ZINAR(1)) and estimates its parameters under
a frequentist approach.

For more information about the ZINAR1 package, please refer to:

Aldo M. Garay, João Vitor Ribeiro (2022).
\emph{ZINAR1: Simulates ZINAR(1) Model and Estimates Its Parameters
Under Frequentist Approach}.
R package version 0.1.0. Available at:
\url{https://CRAN.R-project.org/package=ZINAR1}.

Garay, A. M., Ribeiro, J. V. (2021). First-Order Integer Valued AR Processes
with Zero-Inflated Innovations.
In: \emph{Nonstationary Systems: Theory and Applications}, Springer.
DOI: \doi{10.1007/978-3-030-82110-4_2}.

We acknowledge the original authors, Aldo M. Garay and João Vitor Ribeiro,
for their contributions.
}
