% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maize.muchow.model.r
\name{mm.HI.fct}
\alias{mm.HI.fct}
\title{Harvest index function for Muchow et al. (1990) Maize model}
\usage{
mm.HI.fct(day, daysilking, HImax, d1 = 0.015, d2 = 3)
}
\arguments{
\item{day}{: day of the year}

\item{daysilking}{: day of the year for silking (day)}

\item{HImax}{: maximum harvest index - genetic potential (-)}

\item{d1}{: coefficient of the statistical relation (day-1, default : 0.015)}

\item{d2}{: coefficient of the statistical relation (day, default : 3)}
}
\value{
Harvest index
}
\description{
Compute the harvest index.
}
\examples{
plot(1:350, mm.HI.fct(1:350, 200, 0.75), type="l")
}
\seealso{
\code{\link{maize.muchow.model}}, \code{\link{mm.A.fct}}, \code{\link{mm.LN.fct}}, \code{\link{maize.multisy}},
\code{\link{mm.FAS.fct}},\code{\link{maize.muchow.graph}}
}
