\name{sim}

\alias{sim}

\title{Simulating Quantities of Interest}

\description{ Simulate quantities of interest from the estimated model
  output from \code{zelig()} given specified values of explanatory
  variables established in \code{setx()}.  For classical \emph{maximum
    likelihood} models, \code{sim()} uses asymptotic normal
  approximation to the log-likelihood.  For \emph{Bayesian models},
  Zelig simulates quantities of interest from the posterior density,
  whenever possible.  For \emph{robust Bayesian models}, simulations
  are drawn from the identified class of Bayesian posteriors.
  Alternatively, you may generate quantities of interest using
  bootstrapped parameters.  }

\usage{
s.out <- sim(object, x, x1 = NULL, num = c(1000, 100), prev = NULL, 
             bootstrap = FALSE,  bootfn = NULL, \dots)
}

\arguments{
  \item{object}{the output object from \code{\link{zelig}}. }
  \item{x}{values of explanatory variables used for simulation,
      generated by \code{\link{setx}}.  }
  \item{x1}{optional values of explanatory variables (generated by a
      second call of \code{\link{setx}}), used to simulate first
      differences and risk ratios.  (Not available for conditional
      prediction.) }
  \item{num}{the number of simulations, i.e., posterior draws.  If the
      \code{num} argument is omitted, \code{sim} draws 1,000
      simulations by if \code{bootstrap = FALSE} (the default), or 100
      simulations if \code{bootstrap = TRUE}.  You may increase this
      value to improve accuracy.  (Not available for conditional
      prediction.) }
  \item{bootstrap}{a logical value indicating if parameters
    should be generated by re-fitting the model for bootstrapped
    data, rather than from the likelihood or posterior.  (Not
    available for conditional prediction.) }
  \item{bootfn}{a function which governs how the data is
    sampled, re-fits the model, and returns the bootstrapped model
    parameters.  If \code{bootstrap = TRUE} and \code{bootfn = NULL},
    \code{\link{sim}} will sample observations from the original data
    (with
    replacement) until it creates a sampled dataset with the same
    number of observations as the original data.  Alternative
    bootstrap methods include sampling the residuals rather than the
    observations, weighted sampling, and parametric bootstrapping.
    (Not available for conditional prediction.) }  
  \item{\dots}{additional optional arguments passed to
    \code{boot}. }
}

\value{ The output stored in \code{s.out} varies by model.  Use the
  \code{names} command to view the output stored in \code{s.out}.
  Common elements include:  {
  \item{x}{the \code{\link{setx}} values for the explanatory variables,
    used to calculate the quantities of interest (expected values,
    predicted values, etc.). }
  \item{x1}{the optional \code{\link{setx}} object used to simulate
    first differences, and other model-specific quantities of
    interest, such as risk-ratios.}
  \item{call}{the options selected for \code{\link{sim}}, used to
    replicate quantities of interest. } 
\item{zelig.call}{the original command and options for
    \code{\link{zelig}}, used to replicate analyses. }
  \item{num}{the number of simulations requested. }
  \item{par}{the parameters (coefficients, and additional
    model-specific parameters).  You may wish to use the same set of
    simulated parameters to calculate quantities of interest rather
    than simulating another set.}
  \item{qi\$ev}{simulations of the expected values given the
    model and \code{x}. }
  \item{qi\$pr}{simulations of the predicted values given by the
    fitted values. }
  \item{qi\$fd}{simulations of the first differences (or risk
    difference for binary models) for the given \code{x} and \code{x1}.
    The difference is calculated by subtracting the expected values
    given \code{x} from the expected values given \code{x1}.  (If do not
    specify \code{x1}, you will not get first differences or risk
    ratios.) }
  \item{qi\$rr}{simulations of the risk ratios for binary and
    multinomial models.  See specific models for details.}
  \item{qi\$ate.ev}{simulations of the average expected
    treatment effect for the treatment group, using conditional
    prediction. Let \eqn{t_i} be a binary explanatory variable defining
    the treatment (\eqn{t_i=1}) and control (\eqn{t_i=0}) groups.  Then the
    average expected treatment effect for the treatment group is
    \deqn{ \frac{1}{n}\sum_{i=1}^n [ \, Y_i(t_i=1) -
      E[Y_i(t_i=0)] \mid t_i=1 \,],} 
    where \eqn{Y_i(t_i=1)} is the value of the dependent variable for
    observation \eqn{i} in the treatment group.  Variation in the
    simulations are due to uncertainty in simulating \eqn{E[Y_i(t_i=0)]},
    the counterfactual expected value of \eqn{Y_i} for observations in the
    treatment group, under the assumption that everything stays the
    same except that the treatment indicator is switched to \eqn{t_i=0}. }
  \item{qi\$ate.pr}{simulations of the average predicted
    treatment effect for the treatment group, using conditional
    prediction. Let \eqn{t_i} be a binary explanatory variable defining
    the treatment (\eqn{t_i=1}) and control (\eqn{t_i=0}) groups.  Then the
    average predicted treatment effect for the treatment group is
    \deqn{ \frac{1}{n}\sum_{i=1}^n [ \, Y_i(t_i=1) -
      \widehat{Y_i(t_i=0)} \mid t_i=1 \,],} 
    where \eqn{Y_i(t_i=1)} is the value of the dependent variable for
    observation \eqn{i} in the treatment group.  Variation in the
    simulations are due to uncertainty in simulating
    \eqn{\widehat{Y_i(t_i=0)}}, the counterfactual predicted value of
    \eqn{Y_i} for observations in the treatment group, under the
    assumption that everything stays the same except that the
    treatment indicator is switched to \eqn{t_i=0}. }
}

In the case of censored $Y$ in the exponential, Weibull, and lognormal
models, \code{sim} first imputes the uncensored values for $Y$ before
calculating the ATE.  

You may use the \code{\$} operator to extract any of the
above from \code{s.out}.  For example, \code{s.out\$qi\$ev} extracts the
simulated expected values.
}

\seealso{The full Zelig at \url{http://gking.harvard.edu/zelig}, and \code{boot}.  }

\author{
  Kosuke Imai <\email{kimai@princeton.edu}>; Gary King
  <\email{king@harvard.edu}>; Olivia Lau <\email{olau@fas.harvard.edu}>
}

\keyword{file}










