% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FDRcutoff.R
\name{FDRcutoff}
\alias{FDRcutoff}
\title{Find a cut-off according to screen strength.}
\usage{
FDRcutoff(zetaData, negGene, posGene, nonExpGene, combine = FALSE)
}
\arguments{
\item{zetaData}{ZetaScore file calculated by ZetaSuite.}

\item{negGene}{negative control dataset, the siRNAs/genes used as negative controls in screening.}

\item{posGene}{positive control dataset, the siRNAs/genes used as positive controls in screening.}

\item{nonExpGene}{non-expressed gene}

\item{combine}{combine two direction zeta together(TRUE or FALSE),default FALSE}
}
\value{
A list of data.frame and plots, the data.frame is cut off matrix with 6 columns including "Cut_Off","aFDR", "SS","TotalHits","Num_nonExp" and "Type". Plots includes 'Zeta_type' and 'SS_cutOff'.
}
\description{
Find a cutoff according to the Screen Strength (SS) and graph the Screen Strength plot.
Zeta score is used to rank genes, and then, SS is calculated to define a suitable cutoff so that the cutoff can define hits at different confidence intervals.
Formula of SS: SS = 1 - aFDR/bFDR, where aFDR (apparent FDR)  = number of non-expressors identified at hits divided by the total number of hits, bFDR (baseline FDR) = total number of non-expressors divided by all screened genes.
SS plot labels: x-axis: zeta score, y-axis: Screen Strength,
SS value is determined at each bin (m bin in total), then connect individual SS value to generate a simulated SS curve based on balance points. Users may choose one or multiple balance point as the different SS intervals.
}
\examples{
data(nonExpGene)
data(negGene)
data(posGene)
data(ZseqList)
data(countMat)
ZscoreVal <- Zscore(countMat,negGene)
zetaData <- Zeta(ZscoreVal,ZseqList,SVM=FALSE)
cutoffval <- FDRcutoff(zetaData,negGene,posGene,nonExpGene,combine=TRUE)

}
\author{
Yajing Hao, Shuyang Zhang, Junhui Li, Guofeng Zhao, Xiang-Dong Fu
}
\keyword{FDR}
\keyword{ZetaSuite}
\keyword{cutoff}
