% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FrequencyTable.R
\name{FrequencyTable}
\alias{FrequencyTable}
\title{Generate a Frequency Distribution Table for Fish Length Data}
\arguments{
\item{data}{A numeric vector or data frame containing fish length measurements. If a data frame is
provided, the first numeric column will be selected.}

\item{bin_width}{(Optional) A numeric value specifying the bin width for class intervals. If not
provided, the bin width is automatically calculated using Wang's formula.}

\item{Lmax}{(Optional) The maximum observed length of fish. Required only if the maximum length is not provided
and bin width is calculated using Wang's formula.}
}
\value{
A list containing two data frames:
\item{lfqTable}{A frequency table with the length range and frequency.}
\item{lfreq}{A table with the upper limits of bins and their frequencies.}
}
\description{
This function creates a frequency distribution table for fish length data, using
either a custom bin width or Wang's formula to calculate the ideal bin width. If the calculated
bin width is a fraction, it is rounded to the nearest integer.
}
\examples{
# Generate random fish length data
set.seed(123)
fish_lengths <- data.frame(Length = runif(2000, min = 5, max = 70))

# Create a frequency table using Wang's formula (default)
FrequencyTable(data = fish_lengths$Length)

# Create a frequency table with a custom bin width
FrequencyTable(data = fish_lengths$Length, bin_width = 5)

}
