\name{APEXMS}
\alias{APEX_ORBI}
\alias{APEX_LCQ}
\docType{data}
\title{Calculating absolute and relative protein abundance from mass spectrometry-based protein expression data.}
\description{
This dataset contains training ThermoFinnigan LTQ-OrbiTrap (ORBI) and ThermoFinnigan Surveyor/DecaXP+ iontrap (LCQ) data for training of an \code{\link{APEX}} classifier. The dataset was generated by Christine Vogel and Edward M. Marcotte (see references).
}
\usage{data(APEXMS)}
\format{
 A data.frame with the following components:
 \enumerate{
  \item{peptide_sequence}{ character vector: Peptide sequence. }
  \item{apex}{ character vector: observed in experiment: 0 = no; 1 = yes. }
 }
}
\source{
\sQuote{The dataset} was obtained from:\cr
\url{http://marcottelab.org/APEX_Protocol/}.
}
\references{
  Vogel, C. & Marcotte, E. M. \emph{Calculating absolute and relative protein abundance from mass spectrometry-based protein expression data.} Nat Protoc 3, 1444-1451 (2008).
}
\seealso{\code{\link{import}}, \code{\link{ProteinInference}}, \code{\link{AbsoluteQuantification}}, \code{\link{ALF}}, \code{\link{APEX}}, \code{\link{apexFeatures}}, \code{\link{proteotypic}}}
\examples{
data(APEXMS)
}
\keyword{datasets}
\keyword{APEX}
