% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segment_annual_shoots.R
\name{segment_annual_shoots}
\alias{segment_annual_shoots}
\alias{segment_annual_shoots,aRchi-method}
\title{Annual shoot segmentation in tree skeleton}
\usage{
segment_annual_shoots(aRchi, tree_age, segment_reiterations)

\S4method{segment_annual_shoots}{aRchi}(aRchi, tree_age, segment_reiterations)
}
\arguments{
\item{aRchi}{an object of class aRchi containing at least a QSM.}

\item{tree_age}{numeric, optional. The tree age. Helps to achieve more robust segmentation.}

\item{segment_reiterations}{list of numeric values. The parameters to segment traumatic
reiterations based on their age difference with the bearer
annual shoot and their elevation. The list must have the
following form: list(age_difference, elevation_angle) where
age_difference and elevation_angle are numeric vectors.
NOTE the elevation angle is defined relative to the zenith.}
}
\value{
The input aRchi file with an additional field in the QSM slot being the segmented
        annual shoots. NOTE that annual shoot = 1 correspond to the last growing season.
        If traumatic reiteration segmentation was achieved, an additional field
        labeling cylinders that belong to a reiteration is added.
}
\description{
Segment the annual shoots in a tree skeleton based on the detection
             of the branching patterns created by acrotony.
}
\examples{
\donttest{
# import aRchi file
aRchi=system.file("extdata","Tree_2.aRchi",package = "aRchi")
aRchi = aRchi::read_aRchi(aRchi)

# smooth skeleton
aRchi = smooth_skeleton(aRchi)

# segment annual shoots
aRchi = aRchi::segment_annual_shoots(aRchi,tree_age = 13)

plot(aRchi,color="annual_shoots",bg = "white")
}
}
\references{
Lecigne, B., Delagrange, S., & Taugourdeau, O. (2021). Annual Shoot Segmentation and
            Physiological Age Classification from TLS Data in Trees with Acrotonic Growth. Forests, 12(4), 391.
            https://doi.org/10.3390/f12040391
}
