% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_squares.R
\name{canvas_squares}
\alias{canvas_squares}
\title{Draw Squares and Rectangles}
\usage{
canvas_squares(
  colors,
  background = "#000000",
  cuts = 50,
  ratio = 1.618,
  resolution = 200,
  noise = FALSE
)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the borders of the squares.}

\item{cuts}{a positive integer specifying the number of cuts to make.}

\item{ratio}{a value specifying the \code{1:1} ratio for each cut.}

\item{resolution}{resolution of the artwork in pixels per row/column. Increasing the resolution increases the quality of the artwork but also increases the computation time exponentially.}

\item{noise}{logical. Whether to add k-nn noise to the artwork. Note that adding noise increases computation time significantly in large dimensions.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function paints random squares and rectangles. It works by repeatedly cutting into the canvas at random locations and coloring the area that these cuts create.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_squares(colors = colorPalette("retro2"))
}

}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
