% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/canvas_segments.R
\name{canvas_segments}
\alias{canvas_segments}
\title{Draw Segments}
\usage{
canvas_segments(
  colors,
  background = "#fafafa",
  n = 250,
  p = 0.5,
  H = 0.1,
  size = 0.2
)
}
\arguments{
\item{colors}{a string or character vector specifying the color(s) used for the artwork.}

\item{background}{a character specifying the color used for the background.}

\item{n}{a positive integer specifying the number of line segments to draw.}

\item{p}{a value specifying the probability of drawing a vertical line segment.}

\item{H}{a positive value specifying the scaling factor for the line segments.}

\item{size}{a positive value specifying the size of the line segments.}
}
\value{
A \code{ggplot} object containing the artwork.
}
\description{
This function draws line segments on a canvas. The length and direction of the line segments is determined randomly.
}
\examples{
\donttest{
set.seed(1)

# Simple example
canvas_segments(colors = colorPalette("dark1"))
}

}
\seealso{
\code{colorPalette}
}
\author{
Koen Derks, \email{koen-derks@hotmail.com}
}
\keyword{artwork}
\keyword{canvas}
