% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatRCTDataset.R
\name{formatRCTDataset}
\alias{formatRCTDataset}
\title{RCT format for Virtual Twins}
\usage{
formatRCTDataset(dataset, outcome.field, treatment.field, interactions = TRUE)
}
\arguments{
\item{dataset}{data.frame representing RCT's}

\item{outcome.field}{name of the outcome's field in \code{dataset}}

\item{treatment.field}{name of the treatment's field in \code{dataset}}

\item{interactions}{logical. If running VirtualTwins with treatment's
interactions, set to TRUE (default value)}
}
\value{
return data.frame with good format (explained in details section) to run VirtualTwins
}
\description{
\code{formatRCTDataset} returns dataset that Virtual Twins is able to 
analyze.
}
\details{
This function check these differents topic: Outcome must be binary and a 
factor. If numeric with two distincts values, outcome becomes a factor where 
the favorable reponse is the second level. Also, outcome is moved on the 
first column of \code{dataset}.

Treatment must have two distinct numeric values, 0 : no treatment, 1 : 
treatment. Treatment is moved to the second column.

Qualitatives variables must be factor. If it has more than two levels, if 
running VirtualTwins with interaction, it creates dummy variables.
}
\examples{
\dontrun{
data.format <- formatRCTDataset(data, "outcome", "treatment", TRUE)
} 

 
  
}

