% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree.wrapper.R
\name{vt.tree}
\alias{vt.tree}
\title{Trees to find Subgroups}
\usage{
vt.tree(tree.type = "class", vt.difft, sens = ">", threshold = seq(0.5,
  0.8, 0.1), screening = NULL, ...)
}
\arguments{
\item{tree.type}{must be a character. "class" for classification tree, "reg" 
for regression tree.}

\item{vt.difft}{\code{\link{VT.difft}} object. Or return of 
\code{\link{vt.forest}} function.}

\item{sens}{must be a character c(">","<"). See \code{\link{VT.tree}} for 
details.}

\item{threshold}{must be numeric. It can be a unique value or a vector. If 
numeric vector, a list is returned. See \code{\link{VT.tree}} for details.}

\item{screening}{must be logical. If TRUE, only varimp variables of VT.object
is used to create the tree.}

\item{...}{rpart() function parameters. Can be used for any tree.type.}
}
\value{
\code{VT.tree} or a list of \code{VT.tree} depending on threshold 
  dimension. See examples.
}
\description{
\code{vt.tree} is a wrapper of \code{\link{VT.tree.class}} and 
\code{\link{VT.tree.reg}}. With parameter tree.type, any of these two class 
can be used with its own parameter.
}
\details{
See \code{\link{VT.tree}}, \code{\link{VT.tree.class}} and 
\code{\link{VT.tree.reg}} classes.
}
\examples{
\dontrun{
 # data(sepsis)
 vt.o <- vt.data(sepsis, "survival", "THERAPY", T)
 # inside model : 
 vt.f <- vt.forest("one", vt.o)
 # use classification tree
 vt.tr <- vt.tree("class", vt.f, threshold = c(0.01, 0.05))
 # return a list
 class(vt.tr)
 # access one of the tree
 vt.tr$tree1
 # return infos
 vt.tr$tree1$getInfos()
 # ...
}
  
}

