% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_external.R
\name{all_combos}
\alias{all_combos}
\title{Create all possible combinations of a set of variables}
\usage{
all_combos(...)
}
\arguments{
\item{...}{strings. Variable names from which all possible combinations
will be created. Each variable string should be separated by a comma.}
}
\value{
A list of vectors of all possible combinations of the variables
}
\description{
This function creates all possible combinations of a set of variables. The
variables should be given as strings and sep. This function can be used
inside of a call to \code{set_predictors} when creating an aba model.
}
\examples{

data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

# fit model with all combinations of three variables
model <- data \%>\% aba_model() \%>\%
  set_groups(
    everyone(),
    DX_bl \%in\% c('MCI', 'AD')
  ) \%>\%
  set_outcomes(ConvertedToAlzheimers, CSF_ABETA_STATUS_bl) \%>\%
  set_predictors(
    all_combos('PLASMA_ABETA_bl', 'PLASMA_PTAU181_bl', 'PLASMA_NFL_bl')
  ) \%>\%
  set_stats(
    stat_glm(std.beta = TRUE)
  ) \%>\%
  fit()

model_summary <- model \%>\% aba_summary()

}
