% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba_utils.R
\name{set_groups}
\alias{set_groups}
\title{Set the groups of an aba model.}
\usage{
set_groups(object, ..., labels = NULL)
}
\arguments{
\item{object}{An aba model. The model for which you want to set groups.}

\item{...}{comma-separated strings or logical expressions. This specifies
the subsets of the data by which the aba model will filter.}

\item{labels}{vector of strings. Optional labels for printing & plotting.}
}
\value{
An aba model with groups set to the given input.
}
\description{
Groups are the filtered subsets of data which you want to fit statistical
models on. This function supports both string
inputs and logical functions of variables (provided that the data is already
set for the aba model). The inputs should be separated
by a comma, where each input is a different group. You can also specify
labels for each group.
}
\details{
Note that \code{everyone()} or \code{"everyone()"} can be used to specify a group with
no filtering. This can be useful when you want to fit models on the entire
group and on a sub-group.
}
\examples{
data <- adnimerge \%>\% dplyr::filter(VISCODE == 'bl')

# set groups based on logical expressions. Here, data must be supplied first.
model <- data \%>\% aba_model() \%>\%
  set_groups(
    everyone(),
    DX_bl == 'CU',
    (DX_bl \%in\% c('MCI','AD')) & (CSF_ABETA_bl < 880)
  )
print(model)

# specify labels which will be used later for printing & plotting
model <- data \%>\% aba_model() \%>\%
  set_groups(
    everyone(),
    DX_bl == 'CU',
    (DX_bl \%in\% c('MCI','AD')) & (CSF_ABETA_bl < 880),
    labels = c('All participants', 'CU-only', 'Ab+ MCI & AD')
  )
print(model)

# set groups based on strings. No data is required to be supplied first.
model <- aba_model() \%>\%
  set_groups(
    "everyone()",
    "DX_bl == 'CU'",
    "(DX_bl \%in\% c('MCI','AD')) & (CSF_ABETA_bl < 880)"
  )
print(model)

}
