% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZVD.R
\name{ZVD}
\alias{ZVD}
\alias{ZVD.default}
\title{Zero Variance Discriminant Analysis}
\usage{
ZVD(A, ...)

\method{ZVD}{default}(A, scaling = FALSE, get_DVs = FALSE)
}
\arguments{
\item{A}{Matrix, where first column corresponds to class labels.}

\item{...}{Parameters passed to ZVD.default.}

\item{scaling}{Logical whether to rescale data so each feature has variance 1.}

\item{get_DVs}{Logical whether to obtain unpenalized zero-variance discriminant vectors.}
}
\value{
\code{SZVDcv} returns an object of \code{\link{class}} "\code{ZVD}"
       including a list with the following named components:
\describe{
  \item{\code{dvs}}{discriminant vectors (optional).}
  \item{\code{B}}{sample between-class covariance.}
  \item{\code{W}}{sample within-class covariance.}
  \item{\code{N}}{basis for the null space of the sample within-class covariance.}
  \item{\code{mu}}{training mean and variance scaling/centering terms}
  \item{\code{means}}{vectors of sample class-means.}
  \item{\code{k}}{number of classes in given data set.}
  \item{\code{labels}}{list of classes.}
  \item{\code{obs}}{matrix of data observations.}
  \item{\code{class_obs}}{Matrices of observations of each class.}
}

\code{NULL}
}
\description{
Implements the ZVD algorithm to solve dicriminant vectors.
}
\details{
This function should potentially be made internal for the release.
}
\examples{
  # Generate Gaussian data on three classes with bunch of redundant variables

  P <- 300 # Number of variables
  N <- 50 # Number of samples per class

  # Mean for classes, they are zero everywhere except the first 3 coordinates
  m1 <- rep(0,P)
  m1[1] <- 3

  m2 <- rep(0,P)
  m2[2] <- 3

  m3 <- rep(0,P)
  m3[3] <- 3

  # Sample dummy data
  Xtrain <- rbind(MASS::mvrnorm(n=N,mu = m1, Sigma = diag(P)),
              MASS::mvrnorm(n=N,mu = m2, Sigma = diag(P)),
              MASS::mvrnorm(n=N,mu = m3, Sigma = diag(P)))


  # Generate the labels
  Ytrain <- rep(1:3,each=N)

  # Normalize the data
  Xt <- accSDA::normalize(Xtrain)
  Xtrain <- Xt$Xc

  # Train the classifier and increase the sparsity parameter from the default
  # so we penalize more for non-sparse solutions.
  res <- accSDA::ZVD(cbind(Ytrain,Xtrain))
}
\seealso{
Used by: \code{\link{SZVDcv}}.
}
