% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accrual_predict.R
\name{accrual_predict}
\alias{accrual_predict}
\title{accrual_predict}
\usage{
accrual_predict(accrual_df, accrual_fit, target)
}
\arguments{
\item{accrual_df}{accrual data frame produced by \code{accrual_create_df} (optionally with by option as a list)}

\item{accrual_fit}{linear model produced by accrual_linear_model, can be a list with the same length as accrual_df}

\item{target}{target sample size, can be a vector with the same length as accrual_df}
}
\value{
Returns the predicted end date or a list of the predicted end dates
}
\description{
accrual_predict
}
\details{
Prediction of end date based on an accrual data frame produced by \code{accrual_create_df},
a fitted regression model produced by accrual_linear_model and a target sample size.
}
\examples{
\donttest{
set.seed(2020)
enrollment_dates <- as.Date("2018-01-01") + sort(sample(1:30, 50, replace=TRUE))
accrual_df<-accrual_create_df(enrollment_dates)
accrual_model<-accrual_linear_model(accrual_df)
accrual_predict(accrual_df,accrual_model,target=100)

#different start and current date
accrual_df<-accrual_create_df(enrollment_dates,start_date=as.Date("2017-12-01"),
    current_date=as.Date("2018-03-01"))
accrual_model<-accrual_linear_model(accrual_df)
accrual_predict(accrual_df,accrual_model,target=100)

 #accrual_df with by option
 set.seed(2020)
centers<-sample(c("Site 1","Site 2","Site 3"),length(enrollment_dates),replace=TRUE)
 accrual_df<-accrual_create_df(enrollment_dates,by=centers)
accrual_model<-accrual_linear_model(accrual_df)
accrual_predict(accrual_df,accrual_model,target=c(30,30,30,100))
}
}
