% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io_functions.R
\name{read_elmaven}
\alias{read_elmaven}
\title{Natural Abundance correction for Carbon labeled samples}
\usage{
read_elmaven(
  path,
  sheet = NULL,
  compound_database = NULL,
  columns_to_skip = NULL,
  filetype = NULL,
  ...
)
}
\arguments{
\item{path}{Path to input file.}

\item{sheet}{Name of sheet in xlsx file with columns 'compound',
'formula', 'isotopelabel', and one column per sample. Defaults to the
first sheet.}

\item{compound_database}{Path to compound database in csv format. Only used
for classic MAVEN style input when formula is not specified.}

\item{columns_to_skip}{Specify column heading to skip. All other columns not
named 'compound', 'formula', and 'isotopelabel' will be assumed to be
sample names.}

\item{filetype}{Specify file type, default is to determine by file extension.}

\item{\dots}{Pass additional parameters to readxl::read_excel}
}
\value{
List containing three items: "original" data.frame which is result
      of read_excel, "cleaned" data.frame which with columns 'compound',
      'formula', isotope_label', label_index', followed by columns for each
      sample, and "isotope" which is a character indicating the isotope
}
\description{
Natural Abundance correction for Carbon labeled samples
}
\examples{
\dontrun{
read_elmaven_xlsx("ExcelFile", "Sheet1")
}
}
