% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_dbs.R
\name{check_ted}
\alias{check_ted}
\title{Check local TED database against GitHub release}
\usage{
check_ted(
  local_sqlite_path,
  tag = NULL,
  token = Sys.getenv("GITHUB_PAT"),
  algo = "sha256"
)
}
\arguments{
\item{local_sqlite_path}{Path to the local \code{ted.db} file.}

\item{tag}{Optional release tag. If NULL, uses latest release.}

\item{token}{Optional GitHub token. Defaults to \code{Sys.getenv("GITHUB_PAT")}.}

\item{algo}{Hash algorithm used for comparison (default: \code{"sha256"}).}
}
\value{
Returns TRUE if the local database is up to date,
FALSE if it is outdated.
}
\description{
Compares the SHA256 hash of a local TED SQLite database (\code{ted.db})
with the hash stored in the latest (or specified) release on
\code{SLesche/truth-effect-database}.
}
\examples{
\dontrun{
check_ted("ted.db")
}
}
