% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/acme_summary.R
\name{acme.summary}
\alias{acme.summary}
\title{Report Summary of ACME Dataset}
\usage{
acme.summary(fname, spec = "", blind = TRUE, ps = "", plot_scav = FALSE,
  plot_srch = FALSE)
}
\arguments{
\item{fname}{Data, either a string for csv files or a data frame name}

\item{spec}{Species subset. Default (empty string) includes all species in
data set.}

\item{blind}{Logical. If TRUE, assumes FT are unaware of carcasses.}

\item{ps}{Character string, name of Postscript file generated. Default (empty
string) displays plots on console and does not generate postscript file.}

\item{plot_scav}{Logical. If TRUE, persistence plot is output. Default is FALSE.}

\item{plot_srch}{Logical. If TRUE, search efficiency plot is output. Default
is FALSE.}
}
\value{
\code{acme.summary} returns a list with the following components:
\item{params}{5-element vector: alpha and rho parameters for the
Weibull persistence distribution, a and b parameters for the
exponentially decreasing search proficiency, and bt as the bleed-through
parameter.}
\item{Rstar}{Reduction factor (inverse of the inflation factor for mortality
counts).}
\item{T}{First component of R* - carcass fraction found on first search.}
\item{I}{Average interval length, in days.}
}
\description{
Provide various summaries for an event-level dataset, including estaimtes
and plots.
}
\details{
This function takes in an event-level dataset of placement and searches,
and reports various statistics related to ACME. This includes empirical
information such as search intervals, carcass information summaries, and
available scavenger information. This function also reports on estimated
values R* and bleed-through rate. All information is printed to the console.

Users have the option of creating plots of empirical data overlayed on estimated
distributions for both persistance and search efficiency.
}
\examples{
\dontrun{
#If altamont is a file in the working directory
acme.summary('altamont.csv', spec = "BHCO")

#To include plots
acme.summary('altamont.csv',spec = "BHCO", plot_scav = TRUE, plot_srch = TRUE)
}
}

