% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/media_getpath.R
\name{media_getpath}
\alias{media_getpath}
\title{Gets the path of a media file for a transcript}
\usage{
media_getpath(
  t,
  filterFile = ".*\\\\.(wav|mp3|aif|aiff|mp4)",
  returnOnlyFirst = TRUE
)
}
\arguments{
\item{t}{transcript object; transcript for which you want to get the media path.}

\item{filterFile}{Character string; regular expression of file types to look for.}

\item{returnOnlyFirst}{Logical; if \code{TRUE} only the first hit will be returned.}
}
\value{
Character string; path to a media file.
}
\description{
Gets the path of a media file for a transcript
}
\examples{
library(act)

# Please be aware that that the example corpus that comes with the package
# does NOT contain media files. Please download the entire example corpus
# with media files if you want to use this function reasonably.

# You can access the media files linked to a transcript directly using
# the object properties.
examplecorpus@transcripts[["SYNC_rotar_y_flexionar"]]@path.media

# This should give the same result:
act::media_getpath(examplecorpus@transcripts[["SYNC_rotar_y_flexionar"]],
                               returnOnlyFirst=FALSE)

# Get only media files of a certain type, e.g. a wav file, and return only the first match:
act::media_getpath(examplecorpus@transcripts[["SYNC_rotar_y_flexionar"]],
                              filterFile=".*\\\\.wav")
}
\seealso{
\link{media_assign}, \link{media_remove}
}
