% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_tiers_reorder.R
\name{modify_tiers_reorder}
\alias{modify_tiers_reorder}
\title{Reorder tiers in transcripts}
\usage{
modify_tiers_reorder(
  x,
  sortVector,
  filterTranscriptsInclude = "",
  addMissingTiers = FALSE,
  deleteTiersThatAreNotInTheSortVector = FALSE
)
}
\arguments{
\item{x}{Corpus object.}

\item{sortVector}{Vector of one or more character strings; strings are regular expressions, the order within the vector presents the new order of the tiers. Use \* (=two backslashes and a star) to indicate where tiers that are not present in the sort vector but in the transcript should be inserted.}

\item{filterTranscriptsInclude}{Character string; only transcripts that match the regular expression will be affected. Use an empty string for processing all transcripts.}

\item{addMissingTiers}{Logical; if \code{TRUE} all tiers that are given in the sort vector but are missing in the transcript will be added.}

\item{deleteTiersThatAreNotInTheSortVector}{Logical; if \code{TRUE} tiers that are present in the original transcript but not in the sort vector will be deleted.}
}
\value{
Corpus object.
}
\description{
Reorders the positions of tiers in all transcripts of a corpus object. The ordering of the tiers will be done according to a vector of regular expressions.
}
\examples{
library(act)

# Check the order of the existing tiers in the first two transcripts
names(examplecorpus@transcripts[[1]]@tiers)
names(examplecorpus@transcripts[[2]]@tiers)

# Get tiernames to create the sort vector
sortVector <- c(names(examplecorpus@transcripts[[1]]@tiers),
                names(examplecorpus@transcripts[[2]]@tiers))

# Revert the vector for demonstration
sortVector <- sortVector[length(sortVector):1]

# This will only reorder the tiers
examplecorpus <- act::modify_tiers_reorder (x=examplecorpus, 
sortVector=sortVector)

# Check again the order of the tiers
names(examplecorpus@transcripts[[1]]@tiers)
names(examplecorpus@transcripts[[2]]@tiers)

# This will  reorder the tiers and additionally add tiers that are given  
# in the sort vector but not present in the transcript
examplecorpus <- act::modify_tiers_reorder (x=examplecorpus,
sortVector=sortVector,
addMissingTiers=TRUE)
# Check again the tiers
names(examplecorpus@transcripts[[1]]@tiers)
names(examplecorpus@transcripts[[2]]@tiers)

# Insert a tier called "newTier" into all transcripts in the corpus:
for (t in examplecorpus@transcripts) {
 sortVector <- c(names(t@tiers), "newTier")
 examplecorpus <- act::modify_tiers_reorder (x=examplecorpus,
sortVector=sortVector,
filterTranscriptsInclude=t@name,
addMissingTiers=TRUE)
}
# Check for example the first transcript: it now contains a tier called "newTier"
examplecorpus@transcripts[[1]]@tiers
}
