% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migration.R
\name{migration}
\alias{migration}
\title{Migration Analysis}
\usage{
migration(
  tz = NULL,
  sections,
  section.order = NULL,
  datapack = NULL,
  success.arrays = NULL,
  max.interval = 60,
  minimum.detections = 2,
  start.time = NULL,
  stop.time = NULL,
  speed.method = c("last to first", "last to last"),
  speed.warning = NULL,
  speed.error = NULL,
  jump.warning = 2,
  jump.error = 3,
  inactive.warning = NULL,
  inactive.error = NULL,
  exclude.tags = NULL,
  override = NULL,
  report = FALSE,
  auto.open = TRUE,
  discard.orphans = FALSE,
  discard.first = NULL,
  save.detections = FALSE,
  if.last.skip.section = TRUE,
  replicates = NULL,
  disregard.parallels = TRUE,
  GUI = c("needed", "always", "never"),
  print.releases = TRUE,
  plot.detections.by = c("stations", "arrays")
)
}
\arguments{
\item{tz}{The time zone of the study area. Must match one of the values
present in \code{\link[base]{timezones}}.}

\item{sections}{DEPRECATED - list the sections in the spatial input instead.}

\item{section.order}{A vector containing the order by which sections should
be aligned in the results.}

\item{datapack}{A data bundle pre-compiled through the function \code{\link{preload}}.
May be used to run actel analyses based on R objects, rather than input files.}

\item{success.arrays}{The arrays that mark the end of the study area. If a
fish crosses one of these arrays, it is considered to have successfully
migrated through the study area.}

\item{max.interval}{The number of minutes that must pass between detections
for a new event to be created. Defaults to 60.}

\item{minimum.detections}{For tags with only one movement event, defines the
minimum number of times a tag must have been recorded during the study
period for it to be considered true detections and not random noise.
Defaults to 2.}

\item{start.time}{Detection data prior to the timestamp set in
\code{start.time} (in YYYY-MM-DD HH:MM:SS format) is not considered during
the analysis.}

\item{stop.time}{Detection data posterior to the timestamp set in
\code{stop.time} (in YYYY-MM-DD HH:MM:SS format) is not considered during
the analysis.}

\item{speed.method}{Can take two forms: 'last to first' or 'last to last'.
If 'last to first' (default), the last detection on the previous array is matched
to the first detection on the target array to perform the calculations.
If 'last to last', the last detection on ´the previous array is matched to the
last detection on the target array to perform the calculations.}

\item{speed.warning}{If a fish moves at a speed equal or greater than
\code{speed.warning} (in metres per second), a warning is issued. If left
NULL (default), no warnings are issued.}

\item{speed.error}{If a fish moves at a speed equal or greater than
\code{speed.error} (in metres per second), user intervention is suggested.
If left NULL (default), user intervention is never suggested.}

\item{jump.warning}{If a fish crosses a number of arrays equal or greater
than \code{jump.error} without being detected, a warning is issued. If left
NULL (default), no warnings are issued.}

\item{jump.error}{If a fish crosses a number of arrays equal or greater than
\code{jump.error} without being detected, user intervention is suggested.
If left NULL (default), user intervention is never suggested.}

\item{inactive.warning}{If a fish spends a number of days equal or greater
than \code{inactive.error} in a given array at the tail of the respective
detections, a warning is issued. If left NULL (default), no warnings are
issued.}

\item{inactive.error}{If a fish spends a number of days equal or greater than
\code{inactive.error} in a given array at the tail of the respective
detections, user intervention is suggested. If left NULL (default), user
intervention is never suggested.}

\item{exclude.tags}{A vector of tags that should be excluded from the
detection data before any analyses are performed. Intended to be used if
stray tags from a different code space but with the same signal as a target
tag are detected in the study area.}

\item{override}{A vector of signals for which the user intends to manually
define which movement events are valid and invalid.}

\item{report}{Logical. Should an HTML report be created at the end of the
analysis? NOTE: Setting report to TRUE will generate an HTML file in the current
directory. Additionally, if auto.open = TRUE (default), the web browser will
automatically be launched to open the report once the function terminates.}

\item{auto.open}{Logical: Should the report be automatically opened once the
analysis is over? Defaults to TRUE. NOTE: If report = TRUE and auto.open = TRUE,
the web browser will automatically be launched to open the report once the
function terminates.}

\item{discard.orphans}{Logical: Should actel automatically discard
detections that do not fall within receiver deployment periods, or that
were recorded before the respective fish were released?}

\item{discard.first}{A threshold amount of time (in hours) that must pass after
release for the respective detections to be valid. Set to 0 to discard only
the release-to-first-detection calculations.}

\item{save.detections}{Logical: Should the processed detections be saved for
future runs?}

\item{if.last.skip.section}{Logical: Should a fish detected at the last array
of a given section be considered to have disappeared in the next section?}

\item{replicates}{A list containing, for each array to which intra-array
efficiency is to be calculated: The standard names of the stations to be
used as a replicate. See the vignettes for more details.}

\item{disregard.parallels}{Logical:  Should the presence of parallel arrays
invalidate potential efficiency peers? See the vignettes for more details.}

\item{GUI}{One of "needed", "always" or "never". If "needed", a new window is
opened to inspect the movements only when the movements table is too big to be
displayed in R's console. If "always", a graphical interface is always created
when the possibility to invalidate events emerges. If "never", a graphical
interface is never invoked. In this case, if the table to be displayed does
not fit in R's console, a temporary file will be saved and the user will be
prompted to open that file and examine it. Defaults to "needed".}

\item{print.releases}{Logical: Should the release sites be printed in the
study area diagrams?}

\item{plot.detections.by}{The type of y axis desired for the individual
detection plots. One of "stations" (default) or "arrays".}
}
\value{
A list containing:
\itemize{
\item \code{detections}: A list containing all detections for each target fish;
\item \code{valid.detections}: A list containing the valid detections for each target fish;
\item \code{spatial}: A list containing the spatial information used during the analysis;
\item \code{deployments}: A data frame containing the deployments of each receiver;
\item \code{arrays}: A list containing the array details used during the analysis;
\item \code{movements}: A list containing all movement events for each target fish;
\item \code{valid.movements}: A list containing the valid movement events for each target fish;
\item \code{section.movements}: A list containing the valid section shifts for each target fish;
\item \code{status.df}: A data.frame containing summary information for each fish, including the
following columns:
\itemize{
\item \emph{Times.entered.[section]}: Number of times the fish was recorded
entering a given section.
\item \emph{Average.time.until.[section]}: Time spent between release
or leaving another section and reaching at the given section.
\item \emph{Average.speed.to.[section]}: Average speed from release or leaving
one section and reaching the given section (if speed.method = "last to first"),
or from release/leaving one section and leaving the given section (if speed.method
= "last to last").
\item \emph{First.array.[section]}: Array in which the fish was
first detected in a given section
\item \emph{First.station.[section]}: Standard name of the first station
where the fish was detected in a given section
\item \emph{First.arrived.[section]}: Very first arrival time at a given section
\item \emph{Average.time.in.[section]}: Average time spent within a given section
at each stay.
\item \emph{Average.speed.in.[section]}: Average speed within a given section
at each stay (only displayed if speed.method = "last to first").
\item \emph{Last.array.[section]}: Array in which the fish was
last detected in a given section
\item \emph{Last.station.[section]}: Standard name of the last station
where the fish was detected in a given section
\item \emph{Last.left.[section]}: Very last departure time from a given section
\item \emph{Total.time.in[section]}: Total time spent in a given section
\item \emph{Very.last.array}: Last array where the fish was detected
\item \emph{Status}: Fate assigned to the fish
\item \emph{Valid.detections}: Number of valid detections
\item \emph{Invalid.detections}: Number of invalid detections
\item \emph{Backwards.movements}: Number of backward movement events
\item \emph{Max.cons.back.moves}: Longest successive backwards movements
\item \emph{P.type}: Type of processing:
\itemize{
\item 'Skipped' if no data was found for the fish,
\item 'Auto' if no user interaction was required,
\item 'Manual' if user interaction was suggested and the user made
changes to the validity of the events,
\item 'Overridden' if the user listed the fish in the
\code{override} argument.
}
\item \emph{Comments}: Comments left by the user during the analysis
}
\item \code{section.overview}: A data frame containing the number of fish that
disappeared in each section;
\item \code{group.overview}: A list containing the number of known and
estimated fish to have passed through each array, divided by group;
\item \code{release.overview}: A list containing the number of known and
estimated fish to have passed through each array, divided by group and release sites;
\item \code{matrices}: A list of CJS matrices used for the efficiency calculations;
\item \code{overall.CJS}: A list of CJS results of the inter-array CJS calculations;
\item \code{intra.array.CJS}: A list of CJS results of the intra-array CJS calculations;
\item \code{times}: A data frame containing all arrival times (per fish) at each array;
\item \code{rsp.info}: A list containing appendix information for the RSP package;
\item \code{dist.mat}: The distance matrix used in the analysis (if a valid
distance matrix was supplied)
}
}
\description{
The \code{migration} analysis runs the same initial checks as \code{explore},
but on top of it, it analyses the fish behaviour. By selecting the arrays
that lead to success, you can define whether or not your fish survived the
migration. Additional plots help you find out if some fish has been acting
odd. Multiple options allow you to tweak the analysis to fit your study
perfectly.
}
\examples{
\donttest{
# Start by moving to a temporary directory
old.wd <- getwd()
setwd(tempdir())

# Deploy the example workspace
exampleWorkspace("exampleWorkspace")

# Move your R session into the example workspace
setwd("exampleWorkspace")

# run the migration analysis. Ensure the tz argument
# matches the time zone of the study area and that the
# sections match your array names. The line below works
# for the example data.
results <- migration(tz = "Europe/Copenhagen")

# to obtain an HTML report, run the analysis with report = TRUE

# return to original working directory
setwd(old.wd)
rm(old.wd)
}

}
\seealso{
\code{\link{explore}}, \code{\link{residency}}
}
