% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_mets.R
\name{compute_mets}
\alias{compute_mets}
\title{Compute metabolic equivalent of task (MET) values}
\usage{
compute_mets(
  data,
  equation = c("Sasaki et al. (2011) [Adults]", "Santos-Lozano et al. (2013) [Adults]",
    "Freedson et al. (1998) [Adults]", "Santos-Lozano et al. (2013) [Older adults]"),
  weight = 70,
  sex = c("male", "female", "undefined")
)
}
\arguments{
\item{data}{A dataframe obtained using the \code{\link{prepare_dataset}} function.}

\item{equation}{A character string to indicate the equation to be used for estimating METs.}

\item{weight}{A numeric value in kg.}

\item{sex}{A character value.}
}
\value{
A numeric vector.
}
\description{
This function computes metabolic equivalent of task (METs) from weight, sex, accelerometer counts, and a published
equation from one of the following scientific articles: Sasaki et al. (2011; doi:10.1016/j.jsams.2011.04.003); Santos-Lozano et al.
(2013; 10.1055/s-0033-1337945); Freedson et al. (1998; doi: 10.1097/00005768-199805000-00021). This function is wrapped
within the \code{\link{mark_intensity}} function.
}
\examples{
library(magrittr)
file <- system.file("extdata", "acc.agd", package = "activAnalyzer")
mydata <- prepare_dataset(data = file)
mydata_with_wear_marks <- mydata \%>\% mark_wear_time() \%>\% 
dplyr::filter(days == 2 & time >= hms::as_hms("14:00:00") & time <= hms::as_hms("15:00:00")) 
mets <- compute_mets(
    data = mydata_with_wear_marks,
    equation = "Sasaki et al. (2011) [Adults]", 
    weight = 67, 
    sex = "male"
    )
mets

}
