% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_data.R
\docType{data}
\name{sim_data}
\alias{sim_data}
\alias{census_dat}
\alias{withdrawals}
\alias{account_vals}
\title{Simulated annuity data}
\format{
Three data frames containing census records (\code{census_dat}),
withdrawal transactions (\code{withdrawals}), and historical account values
(\code{account_vals}).

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 20000 rows and 11 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 160130 rows and 4 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 141252 rows and 3 columns.
}
\usage{
census_dat

withdrawals

account_vals
}
\description{
Simulated data for a theoretical deferred annuity product with
an optional guaranteed income rider. This data is theoretical only and
does not represent the experience on any specific product.
}
\section{Census data (\code{census_dat})}{
\describe{
\item{pol_num}{policy number}
\item{status}{policy status: Active, Surrender, or Death}
\item{issue_date}{issue date}
\item{inc_guar}{indicates whether the policy was issued with an income guarantee}
\item{qual}{indicates whether the policy was purchased with tax-qualified funds}
\item{age}{issue age}
\item{product}{product: a, b, or c}
\item{gender}{M (Male) or F (Female)}
\item{wd_age}{Age that withdrawals commence}
\item{premium}{Single premium deposit}
\item{term_date}{termination date upon death or surrender}
}
}

\section{Withdrawal data (\code{withdrawals})}{
\describe{
\item{pol_num}{policy number}
\item{trx_date}{withdrawal transaction date}
\item{trx_type}{withdrawal transaction type, either Base or Rider}
\item{trx_amt}{withdrawal transaction amount}
}
}

\section{Account values data (\code{account_vals})}{
\describe{
\item{pol_num}{policy number}
\item{pol_date_yr}{policy anniversary date (beginning of year)}
\item{av_anniv}{account value on the policy anniversary date}
}
}

\keyword{datasets}
