% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adaHuber.R
\name{adaHuber.mean}
\alias{adaHuber.mean}
\title{Adaptive Huber Mean Estimation}
\usage{
adaHuber.mean(X, epsilon = 1e-04, iteMax = 500)
}
\arguments{
\item{X}{An \eqn{n}-dimensional data vector.}

\item{epsilon}{(\strong{optional}) The tolerance level in the iterative estimation procedure, iteration will stop when \eqn{|\mu_new - \mu_old| < \epsilon}. The defalut value is 1e-4.}

\item{iteMax}{(\strong{optional}) Maximum number of iterations. Default is 500.}
}
\value{
A list including the following terms will be returned:
\describe{
\item{\code{mu}}{The Huber mean estimator.}
\item{\code{tau}}{The robustness parameter determined by the tuning-free principle.}
\item{\code{iteration}}{The number of iterations in the estimation procedure.}
}
}
\description{
Adaptive Huber mean estimator from a data sample, with robustification parameter \eqn{\tau} determined by a tuning-free principle.
}
\examples{
n = 1000
mu = 2
X = rt(n, 2) + mu
fit.mean = adaHuber.mean(X)
fit.mean$mu
}
\references{
Huber, P. J. (1964). Robust estimation of a location parameter. Ann. Math. Statist., 35, 73–101.

Wang, L., Zheng, C., Zhou, W. and Zhou, W.-X. (2021). A new principle for tuning-free Huber regression. Stat. Sinica, 31, 2153-2177.
}
