% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_plot.R
\name{PRsurface}
\alias{PRsurface}
\title{Plot the passing-rate curve and the passing-rate surface in IVPT}
\usage{
PRsurface(
  n,
  r,
  observed_GMR = 0.95,
  observed_sigmaWR = 0.294,
  GMR_grid = seq(0.75, 1.3, length.out = 100),
  sigmaWR_grid = seq(0.2, 1, length.out = 100),
  params = list(),
  nsim = 1000,
  ncores = NULL,
  verbose = FALSE,
  plot = TRUE
)
}
\arguments{
\item{n}{The number of donors in each simulation.}

\item{r}{The number of replicates from each donor for each simulated dataset.}

\item{observed_GMR}{The observed (estimated) GMR of the user's data. Along with the observed sigmaWR, the corresponding passing rate will be displayed in the 3D plot as a vertical line parallel to the z-axis.}

\item{observed_sigmaWR}{The observed (estimated) sigmaWR of the user's data. Along with the observed GMR, the corresponding passing rate will be displayed in the 3D plot as a vertical line parallel to the z-axis.}

\item{GMR_grid}{The grid of GMR values to be used for plotting the 3D surface of passing rates.}

\item{sigmaWR_grid}{The grid of sigmaWR values to be used for plotting the 3D surface of passing rates.}

\item{params}{(Optional) The list of true parameters to be assumed in data generation.
\itemize{
\item \code{sigma_W0} - A regulatory constant set by the FDA. Defaults to 0.25.
\item \code{sigma_WT} - The true standard deviation of the test formulation population.
\item \code{sigma_WR} - The true standard deviation of the reference formulation population.
\item \code{GMR} - The geometric mean ratio of the test and reference values of the pharmacokinetic measures (e.g., Jmax or AUC). If the test-formulation measure is greater than that of the reference formulation, then GMR is typically set to 1.05, which is the initial value of this function. If the reference-formulation measure is bigger, then GMR is typically 0.95. Defaults to 0.95.
\item \code{m} - Another regulatory constant that determines the bounds within which the estimated GMR should fall for bioequivalence to be established. Defaults to 1.25, representing 80-125\% average BE limits, which is the FDA recommendation.
\item \code{sig_level} - The significance level (alpha-level). Defaults to 0.05.
}}

\item{nsim}{(Optional) The number of total simulations to be conducted. Defaults to 1,000.}

\item{ncores}{(Optional) The number of CPU cores to use for parallel processing (OpenMP). If R hasn't been installed with OpenMP configured, this will not take effect. When OpenMP is available, it should not exceed the number of existing cores. If unspecified, it will default to 2 cores or the number of existing cores, whichever is smaller.}

\item{verbose}{(Optional) A logical value (\code{TRUE}/\code{FALSE}) indicating whether to display the progress bar.}

\item{plot}{(Optional) A logical value (\code{TRUE}/\code{FALSE}) indicating whether to generate a 3D interactive plot of the surface. If \code{FALSE}, the function will return the (x, y, z) values as a \code{list}.}
}
\value{
A list
\itemize{
\item \code{GMR} - A list of true parameter settings.
\item \code{passing_rate} - The estimated passing rate.
\item \code{runtime} - The total elapsed time charged for the execution of the program.
}
}
\description{
This function plots the power (passing-rate) curve and power (passing-rate) surface of the mixed scaling (MS) approach. A power curve shows the statistical power across different effect sizes. In IVPT studies, the effect size is captured by the difference between the means of log-measurements of the test and reference products (i.e., logGMR). For the passing-rate surface, the corresponding function considers different values of the standard deviation.
}
\examples{
out <- PRsurface(6, 3, GMR_grid = c(0.90, 1), sigmaWR_grid = c(0.2, 0.5), nsim = 2, plot = FALSE)

}
\references{
Davit, B. M., Chen, M. L., Conner, D. P., Haidar, S. H., Kim, S., Lee, C. H., Lionberger, R. A., Makhlouf, F. T., Nwakama, P. E., Patel, D. T., Schuirmann, D. J., & Yu, L. X. (2012). Implementation of a reference-scaled average bioequivalence approach for highly variable generic drug products by the US Food and Drug Administration. The AAPS journal, 14(4), 915-924.
}
\author{
Daeyoung Lim, \email{daeyoung.lim@uconn.edu}
}
