% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/import.R
\name{read.genepop}
\alias{read.genepop}
\title{Reading data from Genepop}
\usage{
read.genepop(file, ncode = 2L, quiet = FALSE)
}
\arguments{
\item{file}{a character string giving the path to the file to convert, with
the appropriate extension.}

\item{ncode}{an integer indicating the number of characters used to code an allele.}

\item{quiet}{logical stating whether a conversion message must be printed
(TRUE,default) or not (FALSE).}
}
\value{
an object of the class \code{genind}
}
\description{
The function \code{read.genepop} reads Genepop data files (.gen) and convert
them into a \linkS4class{genind} object.
}
\details{
Note: \code{read.genepop} is meant for DIPLOID DATA ONLY. Haploid data with
the Genepop format can be read into R using \code{read.table} or
\code{read.csv} after removing headers and 'POP' lines, and then converted
using \code{\link{df2genind}}.
}
\examples{
obj <- read.genepop(system.file("files/nancycats.gen",package="adegenet"))
obj
}
\author{
Thibaut Jombart \email{t.jombart@imperial.ac.uk}
}
\references{
Raymond M. & Rousset F, (1995). GENEPOP (version 1.2):
population genetics software for exact tests and ecumenicism. \emph{J.
Heredity}, \bold{86}:248-249 \cr
}
\seealso{
\code{\link{import2genind}}, \code{\link{df2genind}},
\code{\link{read.fstat}}, \code{\link{read.structure}},
\code{\link{read.genetix}}
}
\keyword{manip}

