% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{predict.cv.grpnet}
\alias{predict.cv.grpnet}
\alias{coef.cv.grpnet}
\title{make predictions from a "cv.grpnet" object.}
\usage{
\method{predict}{cv.grpnet}(object, newx, lambda = c("lambda.1se", "lambda.min"), ...)
}
\arguments{
\item{object}{Fitted \code{"cv.grpnet"}.}

\item{newx}{Matrix of new values for \code{x} at which predictions are to be
made. Can be a matrix, a sparse matrix as in \code{Matrix} package,
or else any of the matrix forms allowable in the \code{adelie} package. This
argument is not used for \code{type="coefficients"}.}

\item{lambda}{Value(s) of the penalty parameter \code{lambda} at which
predictions are required. Default is the value \code{lambda="lambda.1se"} stored
on the CV \code{object}. Alternatively \code{lambda="lambda.min"} can be used. If
\code{lambda} is numeric, it is taken as the value(s) of \code{lambda} to be
used.}

\item{\dots}{Not used. Other arguments to predict.}
}
\value{
The object returned depends on the arguments.
}
\description{
This function makes predictions from a cross-validated grpnet model, using
the stored \code{"grpnet.fit"} object, and the optimal value chosen for
\code{lambda}.
}
\details{
This function makes it easier to use the results of cross-validation to make
a prediction.
}
\examples{

x = matrix(rnorm(100 * 20), 100, 20)
y = rnorm(100)
cv.fit = cv.grpnet(x, glm.gaussian(y))
predict(cv.fit, newx = x[1:5, ])
coef(cv.fit)
coef(cv.fit, lambda = "lambda.min")
predict(cv.fit, newx = x[1:5, ], lambda = c(0.001, 0.002))

}
\references{
Yang, James and Hastie, Trevor. (2024) A Fast and Scalable Pathwise-Solver for Group Lasso
and Elastic Net Penalized Regression via Block-Coordinate Descent. arXiv \doi{10.48550/arXiv.2405.08631}.
}
\seealso{
\code{grpnet}, and \code{print}, and \code{coef} methods, and
\code{cv.grpnet}.
}
\author{
James Yang, Trevor Hastie, and  Balasubramanian Narasimhan \cr Maintainer: Trevor Hastie \href{mailto:hastie@stanford.edu}{hastie@stanford.edu}
}
\keyword{models}
\keyword{regression}
