% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directional.response.R
\name{directional.response}
\alias{directional.response}
\title{Directional indices of community change}
\usage{
directional.response(mat, method = "overlap", relativize = NULL)
}
\arguments{
\item{mat}{A community composition data matrix with sites in rows and species 
in columns. The direction of the physical process is indicated by the order of the 
sampling units in \code{mat}. The class of \code{mat} can be either \code{data.frame} 
or \code{matrix}.}

\item{method}{One of the 11 calculation methods available in the function:
\code{"overlap"}, \code{"gain"}, \code{"loss"}, \code{"gaining.turnover"}, 
\code{"neutral.turnover"}, \code{"losing.turnover"}, \code{"gaining.nestedness"}, 
\code{"neutral.nestedness"}, \code{ "losing.nestedness"}, 
\code{"gaining.strict.nestedness"}, \code{"losing.strict.nestedness"}. 
The default value is \code{method="overlap"}.}

\item{relativize}{Compute relativized indices: \code{relativize="J"} for the
Jaccard denominator (a+b+c) or \code{relativize="S"} for the Sorensen denominator 
(2*a+b+c). If \code{relativize=NULL}, the index is not divided by a denominator.}
}
\value{
A list containing the following results: \itemize{ \item
\code{mat.out}: A square matrix with the chosen index computed among the sites.
 Depending on the method chosen, this matrix may be symmetric or non-symmetric.
\code{total.t}: methods  #4 to 6, a matrix with total turnover (b+c); else NA.
\code{total.n}: For methods #7 to 9, a matrix with total nestedness a+abs(b-c) 
  if a>0; else NA.
\code{total.strict.n}: For methods #10 and 11, a matrix with total strict nestedness 
  a+abs(b-c) if a>0 and b!=c; else NA.
\code{den}: For calculation results with Jaccard or Sorensen denominators: 
	 a square matrix of denominators. If \code{relativize=NULL}, \code{den=NA}. }
}
\description{
Compute directional indices of community change along coenoclines or time.
}
\details{
The output matrix is non-symmetric, meaning that its upper triangle is not the mirror 
image of the lower triangle. Given the direction of the physical process through space 
or time indicated by the order of the sampling units, the output matrix \code{mat.out} 
reflects that direction in its non-symmetric presentation, \emph{From} (rows of the 
matrix) \emph{To} (columns of the matrix). Users of the function can extract one or the 
other of these triangular portions and analyse them separately. See Appendix xx for 
examples.
}
\examples{

# Artificial Example
art <- c(1,1,1,0,0,0,
         0,0,0,1,1,0,
         0,0,0,0,0,1)
art.data <- matrix(art, nrow=3, ncol=6, byrow=TRUE)

art.out <- directional.response(art.data, method="overlap",relativize=NULL)

# Real data example: the Doubs River fish data (Verneaux 1973), available in ade4.
# 30 sites, 27 species. No fish had been caught at site 8; remove that site
if(require("ade4", quietly = TRUE)) {

data(doubs)
dim(doubs$fish)   
fish <- doubs$fish[-8,] 
dim(fish)
doubs.out <- directional.response(fish, method="gain", relativize="S")
}

}
\references{
Schmera, D., P. Legendre, T. Eros, M. Toth, E. K. Magyari, B. Baur and J. Podani. 
2022. New measures for quantifying directional changes in presence-absence community 
data. Ecological Indicators 136: 108618. https://doi.org/10.1016/j.ecolind.2022.108618

Verneaux, J. (1973) \emph{Cours d'eau de Franche-Comté (Massif du Jura). 
Recherches écologiques sur le réseau hydrographique du Doubs. Essai de biotypologie}. 
Thèse d'État, Besançon. 1–257.
}
\author{
Dénes Schmera \email{schmera.denes@blki.hu} 
and Pierre Legendre \email{pierre.legendre@umontreal.ca}
}
