% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_merged.R
\name{derive_var_merged_character}
\alias{derive_var_merged_character}
\title{Merge a Character Variable}
\usage{
derive_var_merged_character(
  dataset,
  dataset_add,
  by_vars,
  order = NULL,
  new_var,
  source_var,
  case = NULL,
  filter_add = NULL,
  mode = NULL,
  missing_value = NA_character_
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected.}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars}, the \code{source_var}, and the \code{order}
argument are expected.}

\item{by_vars}{Grouping variables

The input dataset and the selected observations from the additional dataset
are merged by the specified by variables. The by variables must be a unique
key of the selected observations. Variables from the additional dataset can
be renamed by naming the element, i.e., \verb{by_vars = exprs(<name in input dataset> = <name in additional dataset>)}, similar to
the dplyr joins.

\emph{Permitted Values}: list of variables created by \code{exprs()}}

\item{order}{Sort order

If the argument is set to a non-null value, for each by group the first or
last observation from the additional dataset is selected with respect to the
specified order.

Variables defined by the \code{new_vars} argument can be used in the sort order.

\emph{Permitted Values}: list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))} or \code{NULL}}

\item{new_var}{New variable

The specified variable is added to the additional dataset and set to the
transformed value with respect to the \code{case} argument.}

\item{source_var}{Source variable}

\item{case}{Change case

Changes the case of the values of the new variable.

\emph{Default}: \code{NULL}

\emph{Permitted Values}: \code{NULL}, \code{"lower"}, \code{"upper"}, \code{"title"}}

\item{filter_add}{Filter for additional dataset (\code{dataset_add})

Only observations fulfilling the specified condition are taken into account
for merging. If the argument is not specified, all observations are
considered.

Variables defined by the \code{new_vars} argument can be used in the filter
condition.

\emph{Permitted Values}: a condition}

\item{mode}{Selection mode

Determines if the first or last observation is selected. If the \code{order}
argument is specified, \code{mode} must be non-null.

If the \code{order} argument is not specified, the \code{mode} argument is ignored.

\emph{Permitted Values}: \code{"first"}, \code{"last"}, \code{NULL}}

\item{missing_value}{Values used for missing information

The new variable is set to the specified value for all by groups without
observations in the additional dataset.

\emph{Default}: \code{NA_character_}

\emph{Permitted Value}: A character scalar}
}
\value{
The output dataset contains all observations and variables of the
input dataset and additionally the variable specified for \code{new_var} derived
from the additional dataset (\code{dataset_add}).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is \emph{deprecated}, please use \code{derive_vars_merged()} instead.

Merge a character variable from a dataset to the input dataset. The
observations to merge can be selected by a condition and/or selecting the
first or last observation for each by group.
}
\details{
\enumerate{
\item The additional dataset is restricted to the observations matching the
\code{filter_add} condition.
\item The (transformed) character variable is added to the additional dataset.
\item If \code{order} is specified, for each by group the first or last observation
(depending on \code{mode}) is selected.
\item The character variable is merged to the input dataset.
}
}
\seealso{
Other deprecated: 
\code{\link{derive_param_extreme_event}()},
\code{\link{derive_var_basetype}()},
\code{\link{derive_var_confirmation_flag}()},
\code{\link{derive_var_disposition_status}()},
\code{\link{derive_var_last_dose_amt}()},
\code{\link{derive_var_last_dose_date}()},
\code{\link{derive_var_last_dose_grp}()},
\code{\link{derive_var_merged_cat}()},
\code{\link{derive_var_worst_flag}()},
\code{\link{derive_vars_disposition_reason}()},
\code{\link{derive_vars_last_dose}()},
\code{\link{format_eoxxstt_default}()},
\code{\link{format_reason_default}()}
}
\concept{deprecated}
\keyword{deprecated}
