% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_numeric_vector}
\alias{assert_numeric_vector}
\title{Is an Argument a Numeric Vector?}
\usage{
assert_numeric_vector(arg, optional = FALSE)
}
\arguments{
\item{arg}{A function argument to be checked}

\item{optional}{Is the checked parameter optional? If set to \code{FALSE} and \code{arg}
is \code{NULL} then an error is thrown}
}
\value{
The function throws an error if \code{arg} is not a numeric vector.
Otherwise, the input is returned invisibly.
}
\description{
Checks if an argument is a numeric vector
}
\examples{
example_fun <- function(num) {
  assert_numeric_vector(num)
}

example_fun(1:10)

try(example_fun(letters))
}
\author{
Stefan Bundfuss
}
\keyword{assertion}
